/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfindingContext;

public class PathfinderWater
extends PathfinderAbstract {
    private final boolean a;
    private final Long2ObjectMap<PathType> l = new Long2ObjectOpenHashMap();

    public PathfinderWater(boolean allowBreaching) {
        this.a = allowBreaching;
    }

    @Override
    public void a(ChunkCache level, EntityInsentient mob) {
        super.a(level, mob);
        this.l.clear();
    }

    @Override
    public void b() {
        super.b();
        this.l.clear();
    }

    @Override
    public PathPoint a() {
        return this.c(MathHelper.a(this.c.cR().a), MathHelper.a(this.c.cR().b + 0.5), MathHelper.a(this.c.cR().c));
    }

    @Override
    public PathDestination a(double x2, double y2, double z2) {
        return this.b(x2, y2, z2);
    }

    @Override
    public int a(PathPoint[] outputArray, PathPoint node) {
        int i2 = 0;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            PathPoint node1 = this.a(node.a + direction.j(), node.b + direction.k(), node.c + direction.l());
            map.put(direction, node1);
            if (!this.a(node1)) continue;
            outputArray[i2++] = node1;
        }
        for (EnumDirection direction1 : EnumDirection.EnumDirectionLimit.a) {
            PathPoint node2;
            EnumDirection clockWise = direction1.h();
            if (!PathfinderWater.b((PathPoint)map.get(direction1)) || !PathfinderWater.b((PathPoint)map.get(clockWise)) || !this.a(node2 = this.a(node.a + direction1.j() + clockWise.j(), node.b, node.c + direction1.l() + clockWise.l()))) continue;
            outputArray[i2++] = node2;
        }
        return i2;
    }

    protected boolean a(@Nullable PathPoint node) {
        return node != null && !node.i;
    }

    private static boolean b(@Nullable PathPoint node) {
        return node != null && node.k >= 0.0f;
    }

    @Nullable
    protected PathPoint a(int x2, int y2, int z2) {
        float pathfindingMalus;
        PathPoint node = null;
        PathType cachedBlockType = this.b(x2, y2, z2);
        if ((this.a && cachedBlockType == PathType.u || cachedBlockType == PathType.j) && (pathfindingMalus = this.c.a(cachedBlockType)) >= 0.0f) {
            node = this.c(x2, y2, z2);
            node.l = cachedBlockType;
            node.k = Math.max(node.k, pathfindingMalus);
            if (this.b.a().b_(new BlockPosition(x2, y2, z2)).c()) {
                node.k += 8.0f;
            }
        }
        return node;
    }

    protected PathType b(int x2, int y2, int z2) {
        return (PathType)((Object)this.l.computeIfAbsent(BlockPosition.a(x2, y2, z2), l2 -> this.a(this.b, x2, y2, z2)));
    }

    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2) {
        return this.a(context, x2, y2, z2, this.c);
    }

    @Override
    public PathType a(PathfindingContext context, int x2, int y2, int z2, EntityInsentient mob) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = x2; i2 < x2 + this.e; ++i2) {
            for (int i1 = y2; i1 < y2 + this.f; ++i1) {
                for (int i22 = z2; i22 < z2 + this.g; ++i22) {
                    IBlockData blockState = context.a(mutableBlockPos.d(i2, i1, i22));
                    Fluid fluidState = blockState.y();
                    if (fluidState.c() && blockState.a(PathMode.b) && blockState.l()) {
                        return PathType.u;
                    }
                    if (fluidState.a(TagsFluid.a)) continue;
                    return PathType.a;
                }
            }
        }
        IBlockData blockState1 = context.a(mutableBlockPos);
        return blockState1.a(PathMode.b) ? PathType.j : PathType.a;
    }
}

