/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import org.slf4j.Logger;

public class CollectingNeighborUpdater
implements NeighborUpdater {
    private static final Logger b = LogUtils.getLogger();
    private final World c;
    private final int d;
    private final ArrayDeque<c> e = new ArrayDeque();
    private final List<c> f = new ArrayList<c>();
    private int g = 0;

    public CollectingNeighborUpdater(World level, int maxChainedNeighborUpdates) {
        this.c = level;
        this.d = maxChainedNeighborUpdates;
    }

    @Override
    public void a(EnumDirection direction, IBlockData state, BlockPosition pos, BlockPosition neighborPos, int flags, int recursionLevel) {
        this.a(pos, new d(direction, state, pos.j(), neighborPos.j(), flags, recursionLevel));
    }

    @Override
    public void a(BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation) {
        this.a(pos, new e(pos, neighborBlock, orientation));
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        this.a(pos, new a(state, pos.j(), neighborBlock, orientation, movedByPiston));
    }

    @Override
    public void a(BlockPosition pos, Block block, @Nullable EnumDirection facing, @Nullable Orientation orientation) {
        this.a(pos, new b(pos.j(), block, orientation, facing));
    }

    private void a(BlockPosition pos, c updates) {
        boolean flag = this.g > 0;
        boolean flag1 = this.d >= 0 && this.g >= this.d;
        ++this.g;
        if (!flag1) {
            if (flag) {
                this.f.add(updates);
            } else {
                this.e.push(updates);
            }
        } else if (this.g - 1 == this.d) {
            b.error("Too many chained neighbor updates. Skipping the rest. First skipped position: " + pos.x());
        }
        if (!flag) {
            this.a();
        }
    }

    private void a() {
        try {
            block3: while (!this.e.isEmpty() || !this.f.isEmpty()) {
                for (int i2 = this.f.size() - 1; i2 >= 0; --i2) {
                    this.e.push(this.f.get(i2));
                }
                this.f.clear();
                c neighborUpdates = this.e.peek();
                while (this.f.isEmpty()) {
                    if (neighborUpdates.a(this.c)) continue;
                    this.e.pop();
                    continue block3;
                }
            }
        }
        finally {
            this.e.clear();
            this.f.clear();
            this.g = 0;
        }
    }

    record d(EnumDirection a, IBlockData b, BlockPosition c, BlockPosition d, int e, int f) implements c
    {
        @Override
        public boolean a(World level) {
            NeighborUpdater.a(level, this.a, this.c, this.d, this.b, this.e, this.f);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "direction;neighborState;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "direction;neighborState;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "direction;neighborState;pos;neighborPos;updateFlags;updateLimit", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    static interface c {
        public boolean a(World var1);
    }

    record e(BlockPosition a, Block b, @Nullable Orientation c) implements c
    {
        @Override
        public boolean a(World level) {
            IBlockData blockState = level.a_(this.a);
            NeighborUpdater.a(level, blockState, this.a, this.b, this.c, false);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "pos;block;orientation", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "pos;block;orientation", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "pos;block;orientation", "a", "b", "c"}, this, o2);
        }
    }

    record a(IBlockData a, BlockPosition b, Block c, @Nullable Orientation d, boolean e) implements c
    {
        @Override
        public boolean a(World level) {
            NeighborUpdater.a(level, this.a, this.b, this.c, this.d, this.e);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "state;pos;block;orientation;movedByPiston", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "state;pos;block;orientation;movedByPiston", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "state;pos;block;orientation;movedByPiston", "a", "b", "c", "d", "e"}, this, o2);
        }
    }

    static final class b
    implements c {
        private final BlockPosition a;
        private final Block b;
        @Nullable
        private Orientation c;
        @Nullable
        private final EnumDirection d;
        private int e = 0;

        b(BlockPosition sourcePos, Block sourceBlock, @Nullable Orientation orientation, @Nullable EnumDirection skipDirection) {
            this.a = sourcePos;
            this.b = sourceBlock;
            this.c = orientation;
            this.d = skipDirection;
            if (NeighborUpdater.a[this.e] == skipDirection) {
                ++this.e;
            }
        }

        @Override
        public boolean a(World level) {
            EnumDirection direction = NeighborUpdater.a[this.e++];
            BlockPosition blockPos = this.a.a(direction);
            IBlockData blockState = level.a_(blockPos);
            Orientation orientation = null;
            if (level.K().b(FeatureFlags.c)) {
                if (this.c == null) {
                    this.c = ExperimentalRedstoneUtils.a(level, this.d == null ? null : this.d.g(), null);
                }
                orientation = this.c.b(direction);
            }
            NeighborUpdater.executeUpdate(level, blockState, blockPos, this.b, orientation, false, this.a);
            if (this.e < NeighborUpdater.a.length && NeighborUpdater.a[this.e] == this.d) {
                ++this.e;
            }
            return this.e < NeighborUpdater.a.length;
        }
    }
}

