/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private BlockPosition k;
    private float l;
    private long m;
    private long n;
    @Nullable
    private final NBTTagCompound o;
    private final int p;
    private int q;
    private boolean r;
    private int s;
    private boolean t;
    private int u;
    private boolean v;
    private boolean w;
    private WorldBorder.d x;
    private EnderDragonBattle.a y;
    @Nullable
    private NBTTagCompound z;
    private int A;
    private int B;
    @Nullable
    private UUID C;
    private final Set<String> D;
    private boolean E;
    private final Set<String> F;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> G;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound loadedPlayerTag, boolean wasModded, BlockPosition spawnPos, float spawnAngle, long gameTime, long dayTime, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.d worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> knownServerBrands, Set<String> removedFeatureFlags, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, EnderDragonBattle.a endDragonFightData, WorldSettings settings, WorldOptions worldOptions, a specialWorldProperty, Lifecycle worldGenSettingsLifecycle) {
        this.E = wasModded;
        this.k = spawnPos;
        this.l = spawnAngle;
        this.m = gameTime;
        this.n = dayTime;
        this.p = version;
        this.q = clearWeatherTime;
        this.s = rainTime;
        this.r = raining;
        this.u = thunderTime;
        this.t = thundering;
        this.v = initialized;
        this.w = difficultyLocked;
        this.x = worldBorder;
        this.A = wanderingTraderSpawnDelay;
        this.B = wanderingTraderSpawnChance;
        this.C = wanderingTraderId;
        this.D = knownServerBrands;
        this.F = removedFeatureFlags;
        this.o = loadedPlayerTag;
        this.G = scheduledEvents;
        this.z = customBossEvents;
        this.y = endDragonFightData;
        this.g = settings;
        this.h = worldOptions;
        this.i = specialWorldProperty;
        this.j = worldGenSettingsLifecycle;
    }

    public WorldDataServer(WorldSettings settings, WorldOptions worldOptions, a specialWorldProperty, Lifecycle worldGenSettingsLifecycle) {
        this(null, false, BlockPosition.c, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.d, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, settings.h(), worldOptions, specialWorldProperty, worldGenSettingsLifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> tag, WorldSettings levelSettings, a specialWorldProperty, WorldOptions worldOptions, Lifecycle worldGenSettingsLifecycle) {
        long _long = tag.get("Time").asLong(0L);
        return new WorldDataServer(tag.get(b).flatMap(arg_0 -> NBTTagCompound.a.parse(arg_0)).result().orElse(null), tag.get("WasModded").asBoolean(false), new BlockPosition(tag.get("SpawnX").asInt(0), tag.get("SpawnY").asInt(0), tag.get("SpawnZ").asInt(0)), tag.get("SpawnAngle").asFloat(0.0f), _long, tag.get("DayTime").asLong(_long), LevelVersion.a(tag).a(), tag.get("clearWeatherTime").asInt(0), tag.get("rainTime").asInt(0), tag.get("raining").asBoolean(false), tag.get("thunderTime").asInt(0), tag.get("thundering").asBoolean(false), tag.get("initialized").asBoolean(true), tag.get("DifficultyLocked").asBoolean(false), WorldBorder.d.a(tag, WorldBorder.d), tag.get("WanderingTraderSpawnDelay").asInt(0), tag.get("WanderingTraderSpawnChance").asInt(0), tag.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null), tag.get("ServerBrands").asStream().flatMap(brandsDynamic -> brandsDynamic.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), tag.get("removed_features").asStream().flatMap(removedFeaturesDynamic -> removedFeaturesDynamic.asString().result().stream()).collect(Collectors.toSet()), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, tag.get("ScheduledEvents").asStream()), (NBTTagCompound)tag.get("CustomBossEvents").orElseEmptyMap().getValue(), tag.get("DragonFight").read(EnderDragonBattle.a.a).resultOrPartial(arg_0 -> ((Logger)f).error(arg_0)).orElse(EnderDragonBattle.a.b), levelSettings, worldOptions, specialWorldProperty, worldGenSettingsLifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registries, @Nullable NBTTagCompound hostPlayerNBT) {
        if (hostPlayerNBT == null) {
            hostPlayerNBT = this.o;
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.a(registries, compoundTag, hostPlayerNBT);
        return compoundTag;
    }

    private void a(IRegistryCustom registry, NBTTagCompound nbt, @Nullable NBTTagCompound playerNBT) {
        nbt.a("ServerBrands", WorldDataServer.a(this.D));
        nbt.a("WasModded", this.E);
        if (!this.F.isEmpty()) {
            nbt.a("removed_features", WorldDataServer.a(this.F));
        }
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", SharedConstants.b().c());
        compoundTag.a("Id", SharedConstants.b().d().c());
        compoundTag.a("Snapshot", !SharedConstants.b().g());
        compoundTag.a("Series", SharedConstants.b().d().b());
        nbt.a("Version", compoundTag);
        GameProfileSerializer.e(nbt);
        RegistryOps<NBTBase> dynamicOps = registry.a(DynamicOpsNBT.a);
        GeneratorSettings.a(dynamicOps, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : registry.f(Registries.bq))).resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)f).error(arg_0))).ifPresent(worldOptionsTag -> nbt.a(c, (NBTBase)worldOptionsTag));
        nbt.a("GameType", this.g.b().a());
        nbt.a("SpawnX", this.k.u());
        nbt.a("SpawnY", this.k.v());
        nbt.a("SpawnZ", this.k.w());
        nbt.a("SpawnAngle", this.l);
        nbt.a("Time", this.m);
        nbt.a("DayTime", this.n);
        nbt.a("LastPlayed", SystemUtils.e());
        nbt.a(a, this.g.a());
        nbt.a("version", 19133);
        nbt.a("clearWeatherTime", this.q);
        nbt.a("rainTime", this.s);
        nbt.a("raining", this.r);
        nbt.a("thunderTime", this.u);
        nbt.a("thundering", this.t);
        nbt.a("hardcore", this.g.c());
        nbt.a("allowCommands", this.g.e());
        nbt.a("initialized", this.v);
        this.x.a(nbt);
        nbt.a("Difficulty", (byte)this.g.d().a());
        nbt.a("DifficultyLocked", this.w);
        nbt.a("GameRules", this.g.f().a());
        nbt.a("DragonFight", EnderDragonBattle.a.a, this.y);
        if (playerNBT != null) {
            nbt.a(b, playerNBT);
        }
        nbt.a(WorldDataConfiguration.b, this.g.g());
        if (this.z != null) {
            nbt.a("CustomBossEvents", this.z);
        }
        nbt.a("ScheduledEvents", this.G.b());
        nbt.a("WanderingTraderSpawnDelay", this.A);
        nbt.a("WanderingTraderSpawnChance", this.B);
        nbt.b("WanderingTraderId", UUIDUtil.a, this.C);
        nbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(nbt);
    }

    private static NBTTagList a(Set<String> stringCollection) {
        NBTTagList listTag = new NBTTagList();
        stringCollection.stream().map(NBTTagString::a).forEach(listTag::add);
        return listTag;
    }

    @Override
    public BlockPosition a() {
        return this.k;
    }

    @Override
    public float b() {
        return this.l;
    }

    @Override
    public long c() {
        return this.m;
    }

    @Override
    public long d() {
        return this.n;
    }

    @Override
    @Nullable
    public NBTTagCompound w() {
        return this.o;
    }

    @Override
    public void a(long time) {
        this.m = time;
    }

    @Override
    public void b(long time) {
        this.n = time;
    }

    @Override
    public void a(BlockPosition spawnPoint, float angle) {
        this.k = spawnPoint.j();
        this.l = angle;
    }

    @Override
    public String e() {
        return this.g.a();
    }

    @Override
    public int x() {
        return this.p;
    }

    @Override
    public int f() {
        return this.q;
    }

    @Override
    public void a(int time) {
        this.q = time;
    }

    @Override
    public boolean g() {
        return this.t;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.t == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.t = thundering;
    }

    @Override
    public int h() {
        return this.u;
    }

    @Override
    public void b(int time) {
        this.u = time;
    }

    @Override
    public boolean i() {
        return this.r;
    }

    @Override
    public void b(boolean isRaining) {
        this.setRaining(isRaining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean isRaining, WeatherChangeEvent.Cause cause) {
        if (this.r == isRaining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, isRaining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.r = isRaining;
    }

    @Override
    public int j() {
        return this.s;
    }

    @Override
    public void c(int time) {
        this.s = time;
    }

    @Override
    public EnumGamemode k() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode type) {
        this.g = this.g.a(type);
    }

    @Override
    public boolean l() {
        return this.g.c();
    }

    @Override
    public boolean m() {
        return this.g.e();
    }

    @Override
    public boolean n() {
        return this.v;
    }

    @Override
    public void c(boolean initialized) {
        this.v = initialized;
    }

    @Override
    public GameRules o() {
        return this.g.f();
    }

    @Override
    public WorldBorder.d p() {
        return this.x;
    }

    @Override
    public void a(WorldBorder.d serializer) {
        this.x = serializer;
    }

    @Override
    public EnumDifficulty q() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.g = this.g.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.q(), this.r());
        for (EntityPlayer player : this.world.z()) {
            player.f.b(packet);
        }
    }

    @Override
    public boolean r() {
        return this.w;
    }

    @Override
    public void d(boolean locked) {
        this.w = locked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> s() {
        return this.G;
    }

    @Override
    public void a(CrashReportSystemDetails crashReportCategory, LevelHeightAccessor level) {
        IWorldDataServer.super.a(crashReportCategory, level);
        SaveData.super.a(crashReportCategory);
    }

    @Override
    public WorldOptions y() {
        return this.h;
    }

    @Override
    public boolean z() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean A() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle B() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a C() {
        return this.y;
    }

    @Override
    public void a(EnderDragonBattle.a endDragonFightData) {
        this.y = endDragonFightData;
    }

    @Override
    public WorldDataConfiguration D() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration dataConfiguration) {
        this.g = this.g.a(dataConfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound E() {
        return this.z;
    }

    @Override
    public void a(@Nullable NBTTagCompound nbt) {
        this.z = nbt;
    }

    @Override
    public int t() {
        return this.A;
    }

    @Override
    public void d(int delay) {
        this.A = delay;
    }

    @Override
    public int u() {
        return this.B;
    }

    @Override
    public void e(int chance) {
        this.B = chance;
    }

    @Override
    @Nullable
    public UUID v() {
        return this.C;
    }

    @Override
    public void a(UUID id) {
        this.C = id;
    }

    @Override
    public void a(String name, boolean isModded) {
        this.D.add(name);
        this.E |= isModded;
    }

    @Override
    public boolean F() {
        return this.E;
    }

    @Override
    public Set<String> G() {
        return ImmutableSet.copyOf(this.D);
    }

    @Override
    public Set<String> H() {
        return Set.copyOf(this.F);
    }

    @Override
    public IWorldDataServer I() {
        return this;
    }

    @Override
    public WorldSettings J() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            d = net.minecraft.world.level.storage.WorldDataServer$a.a();
        }
    }
}

