/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class WorldNBTStorage {
    private static final Logger b = LogUtils.getLogger();
    private final File c;
    protected final DataFixer a;
    private static final DateTimeFormatter d = FileNameDateFormatter.a();

    public WorldNBTStorage(Convertable.ConversionSession levelStorageAccess, DataFixer fixerUpper) {
        this.a = fixerUpper;
        this.c = levelStorageAccess.a(SavedFile.c).toFile();
        this.c.mkdirs();
    }

    public void a(EntityHuman player) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            NBTTagCompound compoundTag = player.h(new NBTTagCompound());
            Path path = this.c.toPath();
            Path path1 = Files.createTempFile(path, player.cH() + "-", ".dat", new FileAttribute[0]);
            NBTCompressedStreamTools.a(compoundTag, path1);
            Path path2 = path.resolve(player.cH() + ".dat");
            Path path3 = path.resolve(player.cH() + ".dat_old");
            SystemUtils.a(path2, path1, path3);
        }
        catch (Exception var7) {
            b.warn("Failed to save player data for {}", (Object)player.cI(), (Object)var7);
        }
    }

    private void backup(String name, String stringUuid, String suffix) {
        Path path = this.c.toPath();
        Path path1 = path.resolve(stringUuid + suffix);
        Path path2 = path.resolve(stringUuid + "_corrupted_" + LocalDateTime.now().format(d) + suffix);
        if (Files.isRegularFile(path1, new LinkOption[0])) {
            try {
                Files.copy(path1, path2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (Exception var7) {
                b.warn("Failed to copy the player.dat file for {}", (Object)name, (Object)var7);
            }
        }
    }

    private Optional<NBTTagCompound> load(String name, String stringUuid, String suffix) {
        File file = new File(this.c, stringUuid + suffix);
        boolean usingWrongFile = false;
        if (Bukkit.getOnlineMode() && !file.exists() && (file = new File(this.c, UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8)).toString() + suffix)).exists()) {
            usingWrongFile = true;
            b.warn("Using offline mode UUID file for player {} as it is the only copy we can find.", (Object)name);
        }
        if (file.exists() && file.isFile()) {
            try {
                Optional<NBTTagCompound> optional = Optional.of(NBTCompressedStreamTools.a(file.toPath(), NBTReadLimiter.a()));
                if (usingWrongFile) {
                    file.renameTo(new File(file.getPath() + ".offline-read"));
                }
                return optional;
            }
            catch (Exception var5) {
                b.warn("Failed to load player data for {}", (Object)name);
            }
        }
        return Optional.empty();
    }

    public Optional<NBTTagCompound> b(EntityHuman player) {
        return this.load(player.ah().getString(), player.cH()).map(tag -> {
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CraftPlayer craftPlayer = serverPlayer.getBukkitEntity();
                long modified = new File(this.c, player.cH() + ".dat").lastModified();
                if (modified < craftPlayer.getFirstPlayed()) {
                    craftPlayer.setFirstPlayed(modified);
                }
            }
            player.i((NBTTagCompound)tag);
            return tag;
        });
    }

    public Optional<NBTTagCompound> load(String name, String uuid) {
        Optional<NBTTagCompound> optional = this.load(name, uuid, ".dat");
        if (optional.isEmpty()) {
            this.backup(name, uuid, ".dat");
        }
        return optional.or(() -> this.load(name, uuid, ".dat_old")).map(compoundTag -> {
            int dataVersion = GameProfileSerializer.b(compoundTag, -1);
            compoundTag = DataFixTypes.b.a(this.a, (NBTTagCompound)compoundTag, dataVersion);
            return compoundTag;
        });
    }

    public File getPlayerDir() {
        return this.c;
    }
}

