/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final LootParams a;
    private final RandomSource b;
    private final HolderGetter.a c;
    private final Set<c<?>> d = Sets.newLinkedHashSet();

    LootTableInfo(LootParams params, RandomSource random, HolderGetter.a lootDataResolver) {
        this.a = params;
        this.b = random;
        this.c = lootDataResolver;
    }

    public boolean a(ContextKey<?> parameter) {
        return this.a.b().a(parameter);
    }

    public <T> T b(ContextKey<T> parameter) {
        return this.a.b().b(parameter);
    }

    @Nullable
    public <T> T c(ContextKey<T> parameter) {
        return this.a.b().c(parameter);
    }

    public void a(MinecraftKey name, Consumer<ItemStack> consumer) {
        this.a.a(name, consumer);
    }

    public boolean a(c<?> element) {
        return this.d.contains(element);
    }

    public boolean b(c<?> element) {
        return this.d.add(element);
    }

    public void c(c<?> element) {
        this.d.remove(element);
    }

    public HolderGetter.a a() {
        return this.c;
    }

    public RandomSource b() {
        return this.b;
    }

    public float c() {
        return this.a.c();
    }

    public WorldServer d() {
        return this.a.a();
    }

    public static c<LootTable> a(LootTable lootTable) {
        return new c<LootTable>(LootDataType.c, lootTable);
    }

    public static c<LootItemCondition> a(LootItemCondition predicate) {
        return new c<LootItemCondition>(LootDataType.a, predicate);
    }

    public static c<LootItemFunction> a(LootItemFunction modifier) {
        return new c<LootItemFunction>(LootDataType.b, modifier);
    }

    public record c<T>(LootDataType<T> a, T b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "type;value", "a", "b"}, this, o2);
        }
    }

    public static final class EntityTarget
    extends Enum<EntityTarget>
    implements INamable {
        public static final /* enum */ EntityTarget a = new EntityTarget("this", LootContextParameters.a);
        public static final /* enum */ EntityTarget b = new EntityTarget("attacker", LootContextParameters.d);
        public static final /* enum */ EntityTarget c = new EntityTarget("direct_attacker", LootContextParameters.e);
        public static final /* enum */ EntityTarget d = new EntityTarget("attacking_player", LootContextParameters.b);
        public static final INamable.a<EntityTarget> e;
        private final String f;
        private final ContextKey<? extends Entity> g;
        private static final /* synthetic */ EntityTarget[] h;

        public static EntityTarget[] values() {
            return (EntityTarget[])h.clone();
        }

        public static EntityTarget valueOf(String name) {
            return Enum.valueOf(EntityTarget.class, name);
        }

        private EntityTarget(String name, ContextKey<? extends Entity> param) {
            this.f = name;
            this.g = param;
        }

        public ContextKey<? extends Entity> a() {
            return this.g;
        }

        public static EntityTarget a(String name) {
            EntityTarget entityTarget = e.a(name);
            if (entityTarget != null) {
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + name);
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{a, b, c, d};
        }

        static {
            h = EntityTarget.b();
            e = INamable.a(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams a;
        @Nullable
        private RandomSource b;

        public Builder(LootParams params) {
            this.a = params;
        }

        public Builder a(long seed) {
            if (seed != 0L) {
                this.b = RandomSource.a(seed);
            }
            return this;
        }

        public Builder a(RandomSource random) {
            this.b = random;
            return this;
        }

        public WorldServer a() {
            return this.a.a();
        }

        public LootTableInfo a(Optional<MinecraftKey> sequence) {
            WorldServer level = this.a();
            MinecraftServer server = level.p();
            RandomSource randomSource = Optional.ofNullable(this.b).or(() -> sequence.map(level::a)).orElseGet(level::G_);
            return new LootTableInfo(this.a, randomSource, server.bc().a());
        }
    }
}

