/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class NestedLootTable
extends LootSelectorEntry {
    public static final MapCodec<NestedLootTable> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either(LootTable.a, LootTable.d).fieldOf("value").forGetter(lootTable -> lootTable.j)).and(NestedLootTable.b(instance)).apply((Applicative)instance, NestedLootTable::new));
    private final Either<ResourceKey<LootTable>, LootTable> j;

    private NestedLootTable(Either<ResourceKey<LootTable>, LootTable> contents, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
        this.j = contents;
    }

    @Override
    public LootEntryType a() {
        return LootEntries.d;
    }

    @Override
    public void a(Consumer<ItemStack> stackConsumer, LootTableInfo lootContext) {
        this.j.map(resourceKey -> lootContext.a().c(resourceKey).map(Holder::a).orElse(LootTable.f), lootTable -> lootTable).a(lootContext, stackConsumer);
    }

    @Override
    public void a(LootCollector validationContext) {
        Optional<ResourceKey<LootTable>> optional = this.j.left();
        if (optional.isPresent()) {
            ResourceKey<LootTable> resourceKey = optional.get();
            if (!validationContext.b()) {
                validationContext.b("Uses reference to " + String.valueOf(resourceKey.a()) + ", but references are not allowed");
                return;
            }
            if (validationContext.a(resourceKey)) {
                validationContext.b("Table " + String.valueOf(resourceKey.a()) + " is recursively called");
                return;
            }
        }
        super.a(validationContext);
        this.j.ifLeft(resourceKey1 -> validationContext.a().c(resourceKey1).ifPresentOrElse(reference -> ((LootTable)reference.a()).a(validationContext.a("->{" + String.valueOf(resourceKey1.a()) + "}", (ResourceKey<?>)resourceKey1)), () -> validationContext.b("Unknown loot table called " + String.valueOf(resourceKey1.a())))).ifRight(lootTable -> lootTable.a(validationContext.a("->{inline}")));
    }

    public static LootSelectorEntry.a<?> a(ResourceKey<LootTable> lootTable) {
        return NestedLootTable.a((int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) -> new NestedLootTable(Either.left(lootTable), weight, quality, conditions, functions));
    }

    public static LootSelectorEntry.a<?> a(LootTable lootTable) {
        return NestedLootTable.a((int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) -> new NestedLootTable(Either.right(lootTable), weight, quality, conditions, functions));
    }
}

