/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootItemFunctionEnchant
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<LootItemFunctionEnchant> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionEnchant.a(instance).and(instance.group((App)RegistryCodecs.a(Registries.aR).optionalFieldOf("options").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.c), (App)Codec.BOOL.optionalFieldOf("only_compatible", (Object)true).forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.d))).apply((Applicative)instance, LootItemFunctionEnchant::new));
    private final Optional<HolderSet<Enchantment>> c;
    private final boolean d;

    LootItemFunctionEnchant(List<LootItemCondition> predicates, Optional<HolderSet<Enchantment>> options, boolean onlyCompatible) {
        super(predicates);
        this.c = options;
        this.d = onlyCompatible;
    }

    public LootItemFunctionType<LootItemFunctionEnchant> b() {
        return LootItemFunctions.h;
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        RandomSource random = context.b();
        boolean isBook = stack.a(Items.rF);
        boolean flag = !isBook && this.d;
        Stream<Holder> stream = this.c.map(HolderSet::a).orElseGet(() -> context.d().J_().f(Registries.aR).c().map(Function.identity())).filter(holder -> !flag || ((Enchantment)holder.a()).c(stack));
        List<Holder> list = stream.toList();
        Optional<Holder> randomSafe = SystemUtils.b(list, random);
        if (randomSafe.isEmpty()) {
            b.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        return LootItemFunctionEnchant.a(stack, randomSafe.get(), random);
    }

    private static ItemStack a(ItemStack stack, Holder<Enchantment> enchantment, RandomSource random) {
        int randomInt = MathHelper.a(random, enchantment.a().d(), enchantment.a().e());
        if (stack.a(Items.rF)) {
            stack = new ItemStack(Items.vG);
        }
        stack.a(enchantment, randomInt);
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static a a(HolderLookup.a registries) {
        return LootItemFunctionEnchant.c().a(registries.e(Registries.aR).b(EnchantmentTags.n));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private Optional<HolderSet<Enchantment>> a = Optional.empty();
        private boolean b = true;

        protected a a() {
            return this;
        }

        public a a(Holder<Enchantment> enchantment) {
            this.a = Optional.of(HolderSet.a(enchantment));
            return this;
        }

        public a a(HolderSet<Enchantment> enchantments) {
            this.a = Optional.of(enchantments);
            return this;
        }

        public a e() {
            this.b = false;
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new LootItemFunctionEnchant(this.g(), this.a, this.b);
        }
    }
}

