/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootItemConditionReference(ResourceKey<LootItemCondition> b) implements LootItemCondition
{
    private final ResourceKey<LootItemCondition> b;
    private static final Logger c = LogUtils.getLogger();
    public static final MapCodec<LootItemConditionReference> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.bt).fieldOf("name").forGetter(LootItemConditionReference::c)).apply((Applicative)instance, LootItemConditionReference::new));

    @Override
    public LootItemConditionType b() {
        return LootItemConditions.p;
    }

    @Override
    public void a(LootCollector context) {
        if (!context.b()) {
            context.b("Uses reference to " + String.valueOf(this.b.a()) + ", but references are not allowed");
        } else if (context.a(this.b)) {
            context.b("Condition " + String.valueOf(this.b.a()) + " is recursively called");
        } else {
            LootItemCondition.super.a(context);
            context.a().c(this.b).ifPresentOrElse(reference -> ((LootItemCondition)reference.a()).a(context.a(".{" + String.valueOf(this.b.a()) + "}", this.b)), () -> context.b("Unknown condition table called " + String.valueOf(this.b.a())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(LootTableInfo context) {
        LootItemCondition lootItemCondition = context.a().c(this.b).map(Holder.c::a).orElse(null);
        if (lootItemCondition == null) {
            c.warn("Tried using unknown condition table called {}", (Object)this.b.a());
            return false;
        }
        LootTableInfo.c<LootItemCondition> visitedEntry = LootTableInfo.a(lootItemCondition);
        if (context.b(visitedEntry)) {
            boolean var4;
            try {
                var4 = lootItemCondition.test(context);
            }
            finally {
                context.c(visitedEntry);
            }
            return var4;
        }
        c.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a a(ResourceKey<LootItemCondition> name) {
        return () -> new LootItemConditionReference(name);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this, o2);
    }

    public ResourceKey<LootItemCondition> c() {
        return this.b;
    }
}

