/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public final class LootItemRandomChanceWithEnchantedBonusCondition
extends Record
implements LootItemCondition {
    private final float b;
    private final LevelBasedValue c;
    private final Holder<Enchantment> g;
    public static final MapCodec<LootItemRandomChanceWithEnchantedBonusCondition> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("unenchanted_chance").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::c), (App)LevelBasedValue.b.fieldOf("enchanted_chance").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::d), (App)Enchantment.c.fieldOf("enchantment").forGetter(LootItemRandomChanceWithEnchantedBonusCondition::e)).apply((Applicative)instance, LootItemRandomChanceWithEnchantedBonusCondition::new));

    public LootItemRandomChanceWithEnchantedBonusCondition(float unenchantedChance, LevelBasedValue enchantedChance, Holder<Enchantment> enchantment) {
        this.b = unenchantedChance;
        this.c = enchantedChance;
        this.g = enchantment;
    }

    @Override
    public LootItemConditionType b() {
        return LootItemConditions.e;
    }

    @Override
    public Set<ContextKey<?>> a() {
        return Set.of(LootContextParameters.d);
    }

    public boolean a(LootTableInfo context) {
        int n2;
        Entity entity = context.c(LootContextParameters.d);
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            n2 = EnchantmentManager.a(this.g, livingEntity);
        } else {
            n2 = 0;
        }
        int i2 = n2;
        float f2 = i2 > 0 ? this.c.a(i2) : this.b;
        return context.b().i() < f2;
    }

    public static LootItemCondition.a a(HolderLookup.a registries, float base, float perLevelAfterFirst) {
        HolderLookup.b<Enchantment> registryLookup = registries.e(Registries.aR);
        return () -> new LootItemRandomChanceWithEnchantedBonusCondition(base, new LevelBasedValue.e(base + perLevelAfterFirst, perLevelAfterFirst), registryLookup.b(Enchantments.s));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemRandomChanceWithEnchantedBonusCondition.class, "unenchantedChance;enchantedChance;enchantment", "b", "c", "g"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemRandomChanceWithEnchantedBonusCondition.class, "unenchantedChance;enchantedChance;enchantment", "b", "c", "g"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemRandomChanceWithEnchantedBonusCondition.class, "unenchantedChance;enchantedChance;enchantment", "b", "c", "g"}, this, o2);
    }

    public float c() {
        return this.b;
    }

    public LevelBasedValue d() {
        return this.c;
    }

    public Holder<Enchantment> e() {
        return this.g;
    }
}

