/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.StorageValue;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NumberProviders {
    private static final Codec<NumberProvider> h = BuiltInRegistries.G.q().dispatch(NumberProvider::b, LootNumberProviderType::a);
    public static final Codec<NumberProvider> a = Codec.lazyInitialized(() -> {
        Codec codec = Codec.withAlternative(h, (Codec)UniformGenerator.a.codec());
        return Codec.either(ConstantValue.b, (Codec)codec).xmap(Either::unwrap, numberProvider -> {
            Either<Object, NumberProvider> either;
            if (numberProvider instanceof ConstantValue) {
                ConstantValue constantValue = (ConstantValue)numberProvider;
                either = Either.left(constantValue);
            } else {
                either = Either.right(numberProvider);
            }
            return either;
        });
    });
    public static final LootNumberProviderType b = NumberProviders.a("constant", ConstantValue.a);
    public static final LootNumberProviderType c = NumberProviders.a("uniform", UniformGenerator.a);
    public static final LootNumberProviderType d = NumberProviders.a("binomial", BinomialDistributionGenerator.a);
    public static final LootNumberProviderType e = NumberProviders.a("score", ScoreboardValue.a);
    public static final LootNumberProviderType f = NumberProviders.a("storage", StorageValue.a);
    public static final LootNumberProviderType g = NumberProviders.a("enchantment_level", EnchantmentLevelProvider.a);

    private static LootNumberProviderType a(String name, MapCodec<? extends NumberProvider> codec) {
        return IRegistry.a(BuiltInRegistries.G, MinecraftKey.b(name), new LootNumberProviderType(codec));
    }
}

