/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class VoxelShapeArray
extends VoxelShape {
    private final DoubleList b;
    private final DoubleList c;
    private final DoubleList d;

    protected VoxelShapeArray(VoxelShapeDiscrete shape, double[] xs, double[] ys, double[] zs) {
        this(shape, (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(xs, shape.b() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(ys, shape.c() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(zs, shape.d() + 1)));
    }

    public VoxelShapeArray(VoxelShapeDiscrete shape, DoubleList xs, DoubleList ys, DoubleList zs) {
        super(shape);
        int i2 = shape.b() + 1;
        int i1 = shape.c() + 1;
        int i22 = shape.d() + 1;
        if (i2 != xs.size() || i1 != ys.size() || i22 != zs.size()) {
            throw SystemUtils.b(new IllegalArgumentException("Lengths of point arrays must be consistent with the size of the VoxelShape."));
        }
        this.b = xs;
        this.c = ys;
        this.d = zs;
        this.moonrise$initCache();
    }

    @Override
    public DoubleList a(EnumDirection.EnumAxis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case EnumDirection.EnumAxis.a -> this.b;
            case EnumDirection.EnumAxis.b -> this.c;
            case EnumDirection.EnumAxis.c -> this.d;
        };
    }
}

