/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public final class TickListChunk<T>
extends Record {
    private final T b;
    private final BlockPosition c;
    private final int d;
    private final TickListPriority e;
    public static final Hash.Strategy<TickListChunk<?>> a = new Hash.Strategy<TickListChunk<?>>(){

        public int a(TickListChunk<?> savedTick) {
            return 31 * savedTick.b().hashCode() + savedTick.a().hashCode();
        }

        public boolean a(@Nullable TickListChunk<?> first, @Nullable TickListChunk<?> second) {
            return first == second || first != null && second != null && first.a() == second.a() && first.b().equals(second.b());
        }
    };

    public TickListChunk(T type, BlockPosition pos, int delay, TickListPriority priority) {
        this.b = type;
        this.c = pos;
        this.d = delay;
        this.e = priority;
    }

    public static <T> Codec<TickListChunk<T>> a(Codec<T> codec) {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(BaseBlockPosition::u), (App)Codec.INT.fieldOf("y").forGetter(BaseBlockPosition::v), (App)Codec.INT.fieldOf("z").forGetter(BaseBlockPosition::w)).apply((Applicative)instance, BlockPosition::new));
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("i").forGetter(TickListChunk::a), (App)mapCodec.forGetter(TickListChunk::b), (App)Codec.INT.fieldOf("t").forGetter(TickListChunk::c), (App)TickListPriority.h.fieldOf("p").forGetter(TickListChunk::d)).apply((Applicative)instance, TickListChunk::new));
    }

    public static <T> List<TickListChunk<T>> a(List<TickListChunk<T>> tickList, ChunkCoordIntPair chunkPos) {
        long packedChunkPos = chunkPos.a();
        return tickList.stream().filter(savedTick -> ChunkCoordIntPair.a(savedTick.b()) == packedChunkPos).toList();
    }

    public NextTickListEntry<T> a(long gameTime, long subTickOrder) {
        return new NextTickListEntry<T>(this.b, this.c, gameTime + (long)this.d, this.e, subTickOrder);
    }

    public static <T> TickListChunk<T> a(T type, BlockPosition pos) {
        return new TickListChunk<T>(type, pos, 0, TickListPriority.d);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this, o2);
    }

    public T a() {
        return this.b;
    }

    public BlockPosition b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public TickListPriority d() {
        return this.e;
    }
}

