/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    ANIMALS_BRED(StatisticList.P),
    AVIATE_ONE_CM(StatisticList.B),
    BELL_RING(StatisticList.az),
    BOAT_ONE_CM(StatisticList.y),
    ARMOR_CLEANED(StatisticList.X),
    BANNER_CLEANED(StatisticList.Y),
    CLEAN_SHULKER_BOX(StatisticList.Z),
    CLIMB_ONE_CM(StatisticList.u),
    CROUCH_ONE_CM(StatisticList.q),
    DAMAGE_ABSORBED(StatisticList.L),
    DAMAGE_BLOCKED_BY_SHIELD(StatisticList.K),
    DAMAGE_DEALT(StatisticList.G),
    DAMAGE_DEALT_ABSORBED(StatisticList.H),
    DAMAGE_DEALT_RESISTED(StatisticList.I),
    DAMAGE_RESISTED(StatisticList.M),
    DAMAGE_TAKEN(StatisticList.J),
    DEATHS(StatisticList.N),
    DROP_COUNT(StatisticList.F),
    CAKE_SLICES_EATEN(StatisticList.U),
    ITEM_ENCHANTED(StatisticList.ak),
    FALL_ONE_CM(StatisticList.t),
    CAULDRON_FILLED(StatisticList.V),
    FISH_CAUGHT(StatisticList.R),
    FLY_ONE_CM(StatisticList.v),
    HORSE_ONE_CM(StatisticList.A),
    DISPENSER_INSPECTED(StatisticList.ae),
    DROPPER_INSPECTED(StatisticList.ac),
    HOPPER_INSPECTED(StatisticList.ad),
    INTERACT_WITH_ANVIL(StatisticList.aC),
    BEACON_INTERACTION(StatisticList.ab),
    INTERACT_WITH_BLAST_FURNACE(StatisticList.as),
    BREWINGSTAND_INTERACTION(StatisticList.aa),
    INTERACT_WITH_CAMPFIRE(StatisticList.av),
    INTERACT_WITH_CARTOGRAPHY_TABLE(StatisticList.aw),
    CRAFTING_TABLE_INTERACTION(StatisticList.an),
    FURNACE_INTERACTION(StatisticList.am),
    INTERACT_WITH_GRINDSTONE(StatisticList.aD),
    INTERACT_WITH_LECTERN(StatisticList.au),
    INTERACT_WITH_LOOM(StatisticList.ax),
    INTERACT_WITH_SMITHING_TABLE(StatisticList.aF),
    INTERACT_WITH_SMOKER(StatisticList.at),
    INTERACT_WITH_STONECUTTER(StatisticList.ay),
    JUMP(StatisticList.E),
    LEAVE_GAME(StatisticList.j),
    MINECART_ONE_CM(StatisticList.x),
    MOB_KILLS(StatisticList.O),
    OPEN_BARREL(StatisticList.ar),
    CHEST_OPENED(StatisticList.ao),
    ENDERCHEST_OPENED(StatisticList.aj),
    SHULKER_BOX_OPENED(StatisticList.aq),
    PIG_ONE_CM(StatisticList.z),
    NOTEBLOCK_PLAYED(StatisticList.af),
    RECORD_PLAYED(StatisticList.al),
    PLAY_ONE_MINUTE(StatisticList.k),
    PLAYER_KILLS(StatisticList.Q),
    FLOWER_POTTED(StatisticList.ah),
    RAID_TRIGGER(StatisticList.aA),
    RAID_WIN(StatisticList.aB),
    SLEEP_IN_BED(StatisticList.ap),
    SNEAK_TIME(StatisticList.o),
    SPRINT_ONE_CM(StatisticList.r),
    STRIDER_ONE_CM(StatisticList.D),
    SWIM_ONE_CM(StatisticList.C),
    TALKED_TO_VILLAGER(StatisticList.S),
    TARGET_HIT(StatisticList.aE),
    TIME_SINCE_DEATH(StatisticList.m),
    TIME_SINCE_REST(StatisticList.n),
    TOTAL_WORLD_TIME(StatisticList.l),
    TRADED_WITH_VILLAGER(StatisticList.T),
    TRAPPED_CHEST_TRIGGERED(StatisticList.ai),
    NOTEBLOCK_TUNED(StatisticList.ag),
    CAULDRON_USED(StatisticList.W),
    WALK_ON_WATER_ONE_CM(StatisticList.s),
    WALK_ONE_CM(StatisticList.p),
    WALK_UNDER_WATER_ONE_CM(StatisticList.w),
    BREAK_ITEM(MinecraftKey.b("broken")),
    CRAFT_ITEM(MinecraftKey.b("crafted")),
    DROP(MinecraftKey.b("dropped")),
    KILL_ENTITY(MinecraftKey.b("killed")),
    ENTITY_KILLED_BY(MinecraftKey.b("killed_by")),
    MINE_BLOCK(MinecraftKey.b("mined")),
    PICKUP(MinecraftKey.b("picked_up")),
    USE_ITEM(MinecraftKey.b("used"));

    private final MinecraftKey minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<MinecraftKey, Statistic> statistics;

    private CraftStatistic(MinecraftKey minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        IRegistry<?> statRegistry = statistic.a().b();
        MinecraftKey nmsKey = BuiltInRegistries.v.b(statistic.a());
        if (statRegistry == BuiltInRegistries.k) {
            nmsKey = (MinecraftKey)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static net.minecraft.stats.Statistic getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        net.minecraft.stats.Statistic<MinecraftKey> nms = StatisticList.i.b((MinecraftKey)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static net.minecraft.stats.Statistic getMaterialStatistic(Statistic stat, Material material) {
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return StatisticList.a.b(CraftBlockType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.CRAFT_ITEM) {
                return StatisticList.b.b(CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.USE_ITEM) {
                return StatisticList.c.b(CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.BREAK_ITEM) {
                return StatisticList.d.b(CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.PICKUP) {
                return StatisticList.e.b(CraftItemType.bukkitToMinecraft(material));
            }
            if (stat == Statistic.DROP) {
                return StatisticList.f.b(CraftItemType.bukkitToMinecraft(material));
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return null;
        }
        return null;
    }

    public static net.minecraft.stats.Statistic getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            EntityTypes<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return StatisticList.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return StatisticList.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(net.minecraft.stats.Statistic<EntityTypes<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(net.minecraft.stats.Statistic<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof Item) {
            Item statisticItemValue = (Item)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof Block) {
            Block statisticBlockValue = (Block)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.dV().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, Material material, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.dV().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, EntityPlayer player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int amount, EntityPlayer player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(ServerStatisticManager manager, Statistic statistic, EntityType entityType, int newValue, EntityPlayer player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        net.minecraft.stats.Statistic nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.dV().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

