/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block;

import java.util.Set;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CraftBlockEntityState<T extends TileEntity>
extends CraftBlockState
implements TileState {
    private final T blockEntity;
    private final T snapshot;
    public boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CraftBlockEntityState(World world, T blockEntity) {
        super(world, ((TileEntity)blockEntity).ax_(), ((TileEntity)blockEntity).m());
        this.blockEntity = blockEntity;
        try {
            this.snapshotDisabled = DISABLE_SNAPSHOT;
            this.snapshot = DISABLE_SNAPSHOT ? this.blockEntity : this.createSnapshot(blockEntity);
            if (this.snapshot != null) {
                this.load(this.snapshot);
            }
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            throw new RuntimeException((String)(world == null ? "Failed to read non-placed BlockState" : "Failed to read BlockState at: world: " + world.getName() + " location: (" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")"), thr);
        }
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.blockEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.blockEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.blockEntity);
    }

    private IRegistryCustom getRegistryAccess() {
        GeneratorAccess worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.J_() : CraftRegistry.getMinecraftRegistry();
    }

    private T createSnapshot(T from) {
        if (from == null) {
            return null;
        }
        NBTTagCompound tag = ((TileEntity)from).b(this.getRegistryAccess());
        return (T)TileEntity.a(this.getPosition(), this.getHandle(), tag, this.getRegistryAccess());
    }

    public Set<DataComponentType<?>> applyComponents(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        Set<DataComponentType<?>> result = ((TileEntity)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public DataComponentMap collectComponents() {
        return ((TileEntity)this.snapshot).q();
    }

    public void loadData(NBTTagCompound tag) {
        ((TileEntity)this.snapshot).c(tag, this.getRegistryAccess());
        this.load(this.snapshot);
    }

    private void copyData(T from, T to) {
        NBTTagCompound tag = ((TileEntity)from).b(this.getRegistryAccess());
        ((TileEntity)to).c(tag, this.getRegistryAccess());
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected TileEntity getBlockEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().c_(this.getPosition());
    }

    public NBTTagCompound getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).b(this.getRegistryAccess());
    }

    public NBTTagCompound getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((TileEntity)this.snapshot).a(this.getRegistryAccess());
    }

    public NBTTagCompound getSnapshotCustomNbtOnly() {
        this.applyTo(this.snapshot);
        NBTTagCompound nbt = ((TileEntity)this.snapshot).e(this.getRegistryAccess());
        ((TileEntity)this.snapshot).a(nbt);
        if (!nbt.j()) {
            ((TileEntity)this.snapshot).c(nbt);
        }
        return nbt;
    }

    protected void load(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(blockEntity, this.snapshot);
        }
    }

    protected void applyTo(T blockEntity) {
        if (blockEntity != null && blockEntity != this.snapshot) {
            this.copyData(this.snapshot, blockEntity);
        }
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced()) {
            this.getWorldHandle().a(this.getPosition(), ((TileEntity)this.blockEntity).p()).ifPresent(blockEntity -> {
                this.applyTo(blockEntity);
                blockEntity.e();
            });
        }
        return result;
    }

    @Override
    public boolean place(int flags) {
        if (super.place(flags)) {
            this.getWorldHandle().a(this.getPosition(), ((TileEntity)this.blockEntity).p()).ifPresent(blockEntity -> {
                this.applyTo(blockEntity);
                blockEntity.e();
            });
            return true;
        }
        return false;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((TileEntity)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> getUpdatePacket(@NotNull Location location) {
        return new PacketPlayOutTileEntityData(CraftLocation.toBlockPosition(location), ((TileEntity)this.snapshot).p(), this.getUpdateNBT());
    }

    @Override
    public abstract CraftBlockEntityState<T> copy();

    @Override
    public abstract CraftBlockEntityState<T> copy(Location var1);

    public boolean isSnapshot() {
        return !this.snapshotDisabled;
    }
}

