/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftLootable<TileEntityChest>
implements Chest {
    public CraftChest(World world, TileEntityChest blockEntity) {
        super(world, blockEntity);
    }

    protected CraftChest(CraftChest state, Location location) {
        super(state, location);
    }

    public Inventory getSnapshotInventory() {
        return new CraftInventory((IInventory)this.getSnapshot());
    }

    public Inventory getBlockInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((IInventory)this.getBlockEntity());
    }

    public Inventory getInventory() {
        CraftInventory inventory = (CraftInventory)this.getBlockInventory();
        if (!this.isPlaced() || this.isWorldGeneration()) {
            return inventory;
        }
        CraftWorld world = (CraftWorld)this.getWorld();
        BlockChest blockChest = (BlockChest)(this.getType() == Material.CHEST ? Blocks.cG : Blocks.hw);
        ITileInventory nms = blockChest.getMenuProvider(this.data, world.getHandle(), this.getPosition(), true);
        if (nms instanceof BlockChest.DoubleInventory) {
            inventory = new CraftInventoryDoubleChest((BlockChest.DoubleInventory)nms);
        }
        return inventory;
    }

    public void open() {
        this.requirePlaced();
        if (!((TileEntityChest)this.getBlockEntity()).f.opened && this.getWorldHandle() instanceof net.minecraft.world.level.World) {
            IBlockData block = ((TileEntityChest)this.getBlockEntity()).m();
            int openCount = ((TileEntityChest)this.getBlockEntity()).f.a();
            ((TileEntityChest)this.getBlockEntity()).f.onAPIOpen((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block);
            ((TileEntityChest)this.getBlockEntity()).f.openerAPICountChanged((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block, openCount, openCount + 1);
        }
        ((TileEntityChest)this.getBlockEntity()).f.opened = true;
    }

    public void close() {
        this.requirePlaced();
        if (((TileEntityChest)this.getBlockEntity()).f.opened && this.getWorldHandle() instanceof net.minecraft.world.level.World) {
            IBlockData block = ((TileEntityChest)this.getBlockEntity()).m();
            int openCount = ((TileEntityChest)this.getBlockEntity()).f.a();
            ((TileEntityChest)this.getBlockEntity()).f.onAPIClose((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block);
            ((TileEntityChest)this.getBlockEntity()).f.openerAPICountChanged((net.minecraft.world.level.World)this.getWorldHandle(), this.getPosition(), block, openCount, 0);
        }
        ((TileEntityChest)this.getBlockEntity()).f.opened = false;
    }

    @Override
    public CraftChest copy() {
        return new CraftChest(this, null);
    }

    @Override
    public CraftChest copy(Location location) {
        return new CraftChest(this, location);
    }

    public boolean isOpen() {
        return ((TileEntityChest)this.getBlockEntity()).f.opened;
    }

    public boolean isBlocked() {
        if (!this.isPlaced()) {
            return false;
        }
        GeneratorAccess world = this.getWorldHandle();
        if (BlockChest.a(world, this.getPosition())) {
            return true;
        }
        if (BlockChest.h(this.data) == DoubleBlockFinder.BlockType.a) {
            return false;
        }
        EnumDirection direction = BlockChest.i(this.data);
        BlockPosition neighbourBlockPos = this.getPosition().a(direction);
        IBlockData neighbourBlockState = world.getBlockStateIfLoaded(neighbourBlockPos);
        return neighbourBlockState != null && neighbourBlockState.a(this.data.b()) && BlockChest.h(neighbourBlockState) != DoubleBlockFinder.BlockType.a && BlockChest.i(neighbourBlockState) == direction.g() && BlockChest.a(world, neighbourBlockPos);
    }
}

