/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.sign.CraftSignSide;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.jetbrains.annotations.NotNull;

public class CraftSign<T extends TileEntitySign>
extends CraftBlockEntityState<T>
implements Sign {
    private final CraftSignSide front = new CraftSignSide(((TileEntitySign)this.getSnapshot()).j());
    private final CraftSignSide back = new CraftSignSide(((TileEntitySign)this.getSnapshot()).k());

    public CraftSign(World world, T blockEntity) {
        super(world, blockEntity);
    }

    protected CraftSign(CraftSign<T> state, Location location) {
        super(state, location);
    }

    public @NotNull List<Component> lines() {
        return this.front.lines();
    }

    public @NotNull Component line(int index) {
        return this.front.line(index);
    }

    public void line(int index, @NotNull Component line) {
        this.front.line(index, line);
    }

    public String[] getLines() {
        return this.front.getLines();
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    public boolean isEditable() {
        return !this.isWaxed();
    }

    public void setEditable(boolean editable) {
        this.setWaxed(!editable);
    }

    public boolean isWaxed() {
        return ((TileEntitySign)this.getSnapshot()).u();
    }

    public void setWaxed(boolean waxed) {
        ((TileEntitySign)this.getSnapshot()).b(waxed);
    }

    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @NotNull
    public SignSide getSide(Side side) {
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        switch (side) {
            case FRONT: {
                return this.front;
            }
            case BACK: {
                return this.back;
            }
        }
        throw new IllegalArgumentException();
    }

    public SignSide getTargetSide(Player player) {
        this.ensureNoWorldGeneration();
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        if (((TileEntitySign)this.getSnapshot()).a(((CraftPlayer)player).getHandle())) {
            return this.front;
        }
        return this.back;
    }

    public Player getAllowedEditor() {
        this.ensureNoWorldGeneration();
        UUID id = ((TileEntitySign)this.getBlockEntity()).t();
        return id == null ? null : Bukkit.getPlayer((UUID)id);
    }

    public DyeColor getColor() {
        return this.front.getColor();
    }

    public void setColor(DyeColor color) {
        this.front.setColor(color);
    }

    @Override
    public void applyTo(T blockEntity) {
        ((TileEntitySign)this.getSnapshot()).a(this.front.applyLegacyStringToSignSide(), true);
        ((TileEntitySign)this.getSnapshot()).a(this.back.applyLegacyStringToSignSide(), false);
        super.applyTo(blockEntity);
    }

    @Override
    public CraftSign<T> copy() {
        return new CraftSign<T>(this, null);
    }

    @Override
    public CraftSign<T> copy(Location location) {
        return new CraftSign<T>(this, location);
    }

    public static void openSign(Sign sign, Player player, Side side) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        PlayerOpenSignEvent event = new PlayerOpenSignEvent(player, sign, side, PlayerOpenSignEvent.Cause.PLUGIN);
        if (!event.callEvent()) {
            return;
        }
        if (PlayerSignOpenEvent.getHandlerList().getRegisteredListeners().length > 0 && !CraftEventFactory.callPlayerSignOpenEvent(player, sign, side, PlayerSignOpenEvent.Cause.PLUGIN)) {
            return;
        }
        TileEntitySign blockEntity = (TileEntitySign)((CraftSign)sign).getBlockEntity();
        blockEntity.a(player.getUniqueId());
        ((CraftPlayer)player).getHandle().a(blockEntity, Side.FRONT == side);
    }

    public static IChatBaseComponent[] sanitizeLines(List<? extends Component> lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.size() && lines.get(i2) != null ? PaperAdventure.asVanilla(lines.get(i2)) : IChatBaseComponent.b("");
        }
        return components;
    }

    public UUID getAllowedEditorUniqueId() {
        this.ensureNoWorldGeneration();
        return ((TileEntitySign)this.getBlockEntity()).t();
    }

    public void setAllowedEditorUniqueId(UUID uuid) {
        this.ensureNoWorldGeneration();
        ((TileEntitySign)this.getBlockEntity()).a(uuid);
    }

    public Side getInteractableSideFor(double x2, double z2) {
        this.requirePlaced();
        return ((TileEntitySign)this.getSnapshot()).isFacingFrontText(x2, z2) ? Side.FRONT : Side.BACK;
    }

    public static IChatBaseComponent[] sanitizeLines(String[] lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.length && lines[i2] != null ? CraftChatMessage.fromString(lines[i2])[0] : IChatBaseComponent.i();
        }
        return components;
    }

    public static String[] revertComponents(IChatBaseComponent[] components) {
        String[] lines = new String[components.length];
        for (int i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = CraftSign.revertComponent(components[i2]);
        }
        return lines;
    }

    private static String revertComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

