/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Vault;
import org.bukkit.craftbukkit.v1_21_R4.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftVault
extends CraftBlockEntityState<VaultBlockEntity>
implements Vault {
    public CraftVault(World world, VaultBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftVault(CraftVault state, @Nullable Location location) {
        super(state, location);
    }

    @Override
    public CraftVault copy() {
        return new CraftVault(this, null);
    }

    @Override
    public CraftVault copy(Location location) {
        return new CraftVault(this, location);
    }

    public double getActivationRange() {
        return ((VaultBlockEntity)this.getSnapshot()).f().c();
    }

    public void setActivationRange(double activationRange) {
        Preconditions.checkArgument((boolean)Double.isFinite(activationRange), (Object)"activation range must not be NaN or infinite");
        Preconditions.checkArgument((activationRange <= this.getDeactivationRange() ? 1 : 0) != 0, (String)"New activation range (%s) must be less or equal to deactivation range (%s)", (Object)activationRange, (Object)this.getDeactivationRange());
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).f();
        ((VaultBlockEntity)this.getSnapshot()).a(new VaultConfig(config.b(), activationRange, config.d(), config.e(), config.f()));
    }

    public double getDeactivationRange() {
        return ((VaultBlockEntity)this.getSnapshot()).f().d();
    }

    public void setDeactivationRange(double deactivationRange) {
        Preconditions.checkArgument((boolean)Double.isFinite(deactivationRange), (Object)"deactivation range must not be NaN or infinite");
        Preconditions.checkArgument((deactivationRange >= this.getActivationRange() ? 1 : 0) != 0, (String)"New deactivation range (%s) must be more or equal to activation range (%s)", (Object)deactivationRange, (Object)this.getActivationRange());
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).f();
        ((VaultBlockEntity)this.getSnapshot()).a(new VaultConfig(config.b(), config.c(), deactivationRange, config.e(), config.f()));
    }

    public ItemStack getKeyItem() {
        return ((VaultBlockEntity)this.getSnapshot()).f().e().asBukkitCopy();
    }

    public void setKeyItem(ItemStack key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null");
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).f();
        ((VaultBlockEntity)this.getSnapshot()).a(new VaultConfig(config.b(), config.c(), config.d(), CraftItemStack.asNMSCopy(key), config.f()));
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(((VaultBlockEntity)this.getSnapshot()).f().b());
    }

    public void setLootTable(LootTable lootTable) {
        ResourceKey<net.minecraft.world.level.storage.loot.LootTable> lootTableKey = CraftLootTable.bukkitToMinecraft(lootTable);
        Preconditions.checkArgument((lootTableKey != null ? 1 : 0) != 0, (Object)"lootTable must not be null");
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).f();
        ((VaultBlockEntity)this.getSnapshot()).a(new VaultConfig(lootTableKey, config.c(), config.d(), config.e(), config.f()));
    }

    public @Nullable LootTable getDisplayedLootTable() {
        return ((VaultBlockEntity)this.getSnapshot()).f().f().map(CraftLootTable::minecraftToBukkit).orElse(null);
    }

    public void setDisplayedLootTable(@Nullable LootTable lootTable) {
        VaultConfig config = ((VaultBlockEntity)this.getSnapshot()).f();
        ((VaultBlockEntity)this.getSnapshot()).a(new VaultConfig(config.b(), config.c(), config.d(), config.e(), Optional.ofNullable(CraftLootTable.bukkitToMinecraft(lootTable))));
    }

    public long getNextStateUpdateTime() {
        return ((VaultBlockEntity)this.getSnapshot()).a.c();
    }

    public void setNextStateUpdateTime(long nextStateUpdateTime) {
        ((VaultBlockEntity)this.getSnapshot()).a.b(nextStateUpdateTime);
    }

    public @Unmodifiable Collection<UUID> getRewardedPlayers() {
        return ImmutableSet.copyOf(((VaultBlockEntity)this.getSnapshot()).a.b());
    }

    public boolean addRewardedPlayer(UUID playerUUID) {
        Preconditions.checkArgument((playerUUID != null ? 1 : 0) != 0, (Object)"playerUUID must not be null");
        return ((VaultBlockEntity)this.getSnapshot()).a.addToRewardedPlayers(playerUUID);
    }

    public boolean removeRewardedPlayer(UUID playerUUID) {
        Preconditions.checkArgument((playerUUID != null ? 1 : 0) != 0, (Object)"playerUUID must not be null");
        return ((VaultBlockEntity)this.getSnapshot()).a.removeFromRewardedPlayers(playerUUID);
    }

    public boolean hasRewardedPlayer(UUID playerUUID) {
        return ((VaultBlockEntity)this.getSnapshot()).a.b().contains(playerUUID);
    }

    public @Unmodifiable Set<UUID> getConnectedPlayers() {
        return ImmutableSet.copyOf(((VaultBlockEntity)this.getSnapshot()).c().d());
    }

    public boolean hasConnectedPlayer(UUID playerUUID) {
        return ((VaultBlockEntity)this.getSnapshot()).c().d().contains(playerUUID);
    }

    public ItemStack getDisplayedItem() {
        return CraftItemStack.asBukkitCopy(((VaultBlockEntity)this.getSnapshot()).c().a());
    }

    public void setDisplayedItem(ItemStack displayedItem) {
        Preconditions.checkArgument((displayedItem != null ? 1 : 0) != 0, (Object)"displayedItem must not be null");
        ((VaultBlockEntity)this.getSnapshot()).c().a(CraftItemStack.asNMSCopy(displayedItem));
    }
}

