/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Gate;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftFenceGate
extends CraftBlockData
implements Gate {
    private static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.e;
    private static final BlockStateBoolean IN_WALL = BlockFenceGate.d;
    private static final BlockStateBoolean OPEN = BlockFenceGate.b;
    private static final BlockStateBoolean POWERED = BlockFenceGate.c;

    public CraftFenceGate(IBlockData state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public boolean isInWall() {
        return this.get(IN_WALL);
    }

    public void setInWall(boolean inWall) {
        this.set(IN_WALL, inWall);
    }

    public boolean isOpen() {
        return this.get(OPEN);
    }

    public void setOpen(boolean open) {
        this.set(OPEN, open);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

