/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.MossyCarpet;
import org.bukkit.block.data.type.Wall;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftMossyCarpet
extends CraftBlockData
implements MossyCarpet {
    private static final BlockStateBoolean BASE = MossyCarpetBlock.b;
    private static final Map<BlockFace, BlockStateEnum<BlockPropertyWallHeight>> PROPERTY_BY_DIRECTION = MossyCarpetBlock.g.entrySet().stream().collect(Collectors.toMap(entry -> CraftBlock.notchToBlockFace((EnumDirection)entry.getKey()), entry -> (BlockStateEnum)entry.getValue()));

    public CraftMossyCarpet(IBlockData state) {
        super(state);
    }

    public boolean isBottom() {
        return this.get(BASE);
    }

    public void setBottom(boolean bottom) {
        this.set(BASE, bottom);
    }

    public Wall.Height getHeight(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateEnum<BlockPropertyWallHeight> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property, Wall.Height.class);
    }

    public void setHeight(BlockFace blockFace, Wall.Height height) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((height != null ? 1 : 0) != 0, (Object)"height cannot be null!");
        BlockStateEnum<BlockPropertyWallHeight> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, height);
    }
}

