/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.block.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.generated.GeneratedFrom;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;

@GeneratedFrom(value="1.21.5")
public class CraftTripWire
extends CraftBlockData
implements Tripwire {
    private static final BlockStateBoolean ATTACHED = BlockTripwire.c;
    private static final BlockStateBoolean DISARMED = BlockTripwire.d;
    private static final BlockStateBoolean POWERED = BlockTripwire.b;
    private static final Map<BlockFace, BlockStateBoolean> PROPERTY_BY_DIRECTION = Map.of(BlockFace.WEST, BlockTripwire.h, BlockFace.EAST, BlockTripwire.f, BlockFace.NORTH, BlockTripwire.e, BlockFace.SOUTH, BlockTripwire.g);

    public CraftTripWire(IBlockData state) {
        super(state);
    }

    public boolean isAttached() {
        return this.get(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.set(ATTACHED, attached);
    }

    public boolean isDisarmed() {
        return this.get(DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.set(DISARMED, disarmed);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }

    public boolean hasFace(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateBoolean property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property);
    }

    public void setFace(BlockFace blockFace, boolean face) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateBoolean property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, face);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (Map.Entry<BlockFace, BlockStateBoolean> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)this.get(entry.getValue())).booleanValue()) continue;
            faces.add((Object)entry.getKey());
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        return Collections.unmodifiableSet(PROPERTY_BY_DIRECTION.keySet());
    }
}

