/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftSound;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public abstract class CraftAbstractArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftAbstractArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    public void setKnockbackStrength(int knockbackStrength) {
    }

    public int getKnockbackStrength() {
        return 0;
    }

    public double getDamage() {
        return this.getHandle().t;
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().h(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().t();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().s();
    }

    public void setCritical(boolean critical) {
        this.getHandle().b(critical);
    }

    public boolean isInBlock() {
        return this.getHandle().e();
    }

    public Block getAttachedBlock() {
        return (Block)Iterables.getFirst(this.getAttachedBlocks(), null);
    }

    public List<Block> getAttachedBlocks() {
        if (!this.isInBlock()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(new VoxelShapeSpliterator<CraftBlock>((ICollisionAccess)this.getHandle().dV(), (Entity)null, new AxisAlignedBB(this.getHandle().dt(), this.getHandle().dt()).g(0.06), false, (mutableBlockPos, voxelShape) -> CraftBlock.at(this.getHandle().dV(), mutableBlockPos)));
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().b.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().b = EntityArrow.PickupStatus.a(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().s = value;
    }

    public boolean isShotFromCrossbow() {
        net.minecraft.world.item.ItemStack firedFromWeapon = this.getHandle().dZ();
        return firedFromWeapon != null && firedFromWeapon.a(Items.xg);
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().aA);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aA = CraftItemStack.asNMSCopy(item);
    }

    public ItemStack getWeapon() {
        if (this.getHandle().dZ() == null) {
            return null;
        }
        return CraftItemStack.asBukkitCopy(this.getHandle().dZ());
    }

    public void setWeapon(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().aB = CraftItemStack.asNMSCopy(item);
    }

    public CraftItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().m());
    }

    public void setItemStack(ItemStack stack) {
        Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().a(CraftItemStack.asNMSCopy(stack));
    }

    public void setLifetimeTicks(int ticks) {
        this.getHandle().s = ticks;
    }

    public int getLifetimeTicks() {
        return this.getHandle().s;
    }

    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().l());
    }

    public void setHitSound(Sound sound) {
        this.getHandle().b(CraftSound.bukkitToMinecraft(sound));
    }

    public void setShooter(ProjectileSource shooter, boolean resetPickupStatus) {
        if (shooter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)shooter;
            this.getHandle().setOwner(craftEntity.getHandle(), resetPickupStatus);
        } else {
            this.getHandle().setOwner(null, resetPickupStatus);
        }
        this.getHandle().projectileSource = shooter;
    }
}

