/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.EntityCow;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractCow;
import org.bukkit.entity.Cow;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftCow
extends CraftAbstractCow
implements Cow {
    public CraftCow(CraftServer server, EntityCow entity) {
        super(server, entity);
    }

    @Override
    public EntityCow getHandle() {
        return (EntityCow)this.entity;
    }

    public Cow.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().p());
    }

    public void setVariant(Cow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().j(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends HolderableBase<CowVariant>
    implements Cow.Variant {
        public static Cow.Variant minecraftToBukkit(CowVariant minecraft) {
            return (Cow.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.aM);
        }

        public static Cow.Variant minecraftHolderToBukkit(Holder<CowVariant> minecraft) {
            return (Cow.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aM);
        }

        public static CowVariant bukkitToMinecraft(Cow.Variant bukkit) {
            return (CowVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CowVariant> bukkitToMinecraftHolder(Cow.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.aM);
        }

        public CraftVariant(Holder<CowVariant> holder) {
            super(holder);
        }
    }
}

