/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.entity.FallingBlock;

public class CraftFallingBlock
extends CraftEntity
implements FallingBlock {
    public CraftFallingBlock(CraftServer server, EntityFallingBlock entity) {
        super(server, entity);
    }

    @Override
    public EntityFallingBlock getHandle() {
        return (EntityFallingBlock)this.entity;
    }

    public Material getMaterial() {
        return this.getBlockData().getMaterial();
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().i());
    }

    public void setBlockData(BlockData blockData) {
        IBlockData newState;
        Preconditions.checkArgument((blockData != null ? 1 : 0) != 0, (Object)"blockData");
        IBlockData oldState = this.getHandle().m;
        this.getHandle().m = newState = ((CraftBlockData)blockData).getState();
        this.getHandle().c = null;
        if (oldState != newState) {
            this.update();
        }
    }

    public BlockState getBlockState() {
        return CraftBlockStates.getBlockState(this.getHandle().m, this.getHandle().c);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState");
        this.setBlockData(blockState.getBlockData());
        if (blockState instanceof CraftBlockEntityState) {
            CraftBlockEntityState blockEntitySnapshot = (CraftBlockEntityState)blockState;
            this.getHandle().c = blockEntitySnapshot.getSnapshotNBT();
        }
    }

    public boolean getDropItem() {
        return this.getHandle().b;
    }

    public void setDropItem(boolean drop) {
        this.getHandle().b = drop;
    }

    public boolean getCancelDrop() {
        return this.getHandle().n;
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.getHandle().n = cancelDrop;
    }

    public boolean canHurtEntities() {
        return this.getHandle().o;
    }

    public void setHurtEntities(boolean hurtEntities) {
        this.getHandle().o = hurtEntities;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().a = value;
    }

    public float getDamagePerBlock() {
        return this.getHandle().q;
    }

    public void setDamagePerBlock(float damage) {
        Preconditions.checkArgument(((double)damage >= 0.0 ? 1 : 0) != 0, (String)"damage must be >= 0.0, given %s", (Object)Float.valueOf(damage));
        this.getHandle().q = damage;
        if ((double)damage > 0.0) {
            this.setHurtEntities(true);
        }
    }

    public int getMaxDamage() {
        return this.getHandle().p;
    }

    public void setMaxDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, given %s", (int)damage);
        this.getHandle().p = damage;
        if (damage > 0) {
            this.setHurtEntities(true);
        }
    }

    public boolean doesAutoExpire() {
        return this.getHandle().autoExpire;
    }

    public void shouldAutoExpire(boolean autoExpires) {
        this.getHandle().autoExpire = autoExpires;
    }
}

