/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.animal.EntityFox;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAnimals;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Player;

public class CraftFox
extends CraftAnimals
implements Fox {
    public CraftFox(CraftServer server, EntityFox entity) {
        super(server, entity);
    }

    @Override
    public EntityFox getHandle() {
        return (EntityFox)this.entity;
    }

    public Fox.Type getFoxType() {
        return Fox.Type.values()[this.getHandle().p().ordinal()];
    }

    public void setFoxType(Fox.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        this.getHandle().a(EntityFox.Type.values()[type.ordinal()]);
    }

    public boolean isCrouching() {
        return this.getHandle().ch();
    }

    public void setCrouching(boolean crouching) {
        this.getHandle().y(crouching);
    }

    public boolean isSitting() {
        return this.getHandle().u();
    }

    public void setSitting(boolean sitting) {
        this.getHandle().w(sitting);
    }

    public void setSleeping(boolean sleeping) {
        this.getHandle().C(sleeping);
    }

    private AnimalTamer getTrustedPlayer(DataWatcherObject<Optional<EntityReference<EntityLiving>>> entityDataKey) {
        return this.getHandle().ar().a(entityDataKey).map(EntityReference::c).map(uuid -> {
            Player player = this.getServer().getPlayer(uuid);
            if (player == null) {
                player = this.getServer().getOfflinePlayer(uuid);
            }
            return player;
        }).orElse(null);
    }

    public AnimalTamer getFirstTrustedPlayer() {
        return this.getTrustedPlayer(EntityFox.bS);
    }

    public void setFirstTrustedPlayer(AnimalTamer player) {
        if (player == null) {
            Preconditions.checkState((boolean)this.getHandle().ar().a(EntityFox.bT).isEmpty(), (Object)"Must remove second trusted player first");
        }
        this.getHandle().ar().a(EntityFox.bS, player == null ? Optional.empty() : Optional.of(new EntityReference(player.getUniqueId())));
    }

    public AnimalTamer getSecondTrustedPlayer() {
        return this.getTrustedPlayer(EntityFox.bT);
    }

    public void setSecondTrustedPlayer(AnimalTamer player) {
        if (player != null) {
            Preconditions.checkState((boolean)this.getHandle().ar().a(EntityFox.bS).isPresent(), (Object)"Must add first trusted player first");
        }
        this.getHandle().ar().a(EntityFox.bT, player == null ? Optional.empty() : Optional.of(new EntityReference(player.getUniqueId())));
    }

    public boolean isFaceplanted() {
        return this.getHandle().gu();
    }

    public void setInterested(boolean interested) {
        this.getHandle().z(interested);
    }

    public boolean isInterested() {
        return this.getHandle().gy();
    }

    public void setLeaping(boolean leaping) {
        this.getHandle().x(leaping);
    }

    public boolean isLeaping() {
        return this.getHandle().gv();
    }

    public void setDefending(boolean defending) {
        this.getHandle().B(defending);
    }

    public boolean isDefending() {
        return this.getHandle().gJ();
    }

    public void setFaceplanted(boolean faceplanted) {
        this.getHandle().A(faceplanted);
    }
}

