/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.TileInventory;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, EntityHuman entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.gj());
        this.enderChest = new CraftInventory(entity.gx());
    }

    @Override
    public EntityHuman getHandle() {
        return (EntityHuman)this.entity;
    }

    public void setHandle(EntityHuman entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.gj());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", uuid=" + String.valueOf(this.getUniqueId()) + "}";
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().fy() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInMainHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInMainHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().bR.g());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().bR.a(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().bR.broadcastCarriedItem();
        }
    }

    @Override
    public void setHurtDirection(float hurtDirection) {
        this.getHandle().cl = hurtDirection;
    }

    public boolean isDeeplySleeping() {
        return this.getHandle().go();
    }

    public int getSleepTicks() {
        return this.getHandle().cv;
    }

    public Location getPotentialRespawnLocation() {
        EntityPlayer.RespawnConfig respawnConfig = ((EntityPlayer)this.getHandle()).S();
        if (respawnConfig == null) {
            return null;
        }
        WorldServer level = ((EntityPlayer)this.getHandle()).g.a(respawnConfig.a());
        if (level == null) {
            return null;
        }
        return CraftLocation.toBukkit(respawnConfig.b(), (World)level.getWorld());
    }

    public FishHook getFishHook() {
        if (this.getHandle().ck == null) {
            return null;
        }
        return (FishHook)this.getHandle().ck.getBukkitEntity();
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        IBlockData state = this.getHandle().dV().a_(pos);
        if (!(state.b() instanceof BlockBed)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(pos, force).left().isPresent()) {
            return false;
        }
        state = (IBlockData)state.b(BlockBed.c, true);
        this.getHandle().dV().a(pos, state, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().a(true, setSpawnLocation);
    }

    public void startRiptideAttack(int duration, float damage, ItemStack attackItem) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Preconditions.checkArgument((damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must not be negative");
        this.getHandle().a(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().fP().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().cI();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        TileEntity blockEntity;
        CraftInventory craft;
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return null;
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        Container formerContainer = this.getHandle().bR;
        ITileInventory menuProvider = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            menuProvider = ((CraftInventoryDoubleChest)inventory).provider;
        } else if (inventory instanceof CraftInventoryLectern) {
            menuProvider = ((CraftInventoryLectern)inventory).provider;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof ITileInventory) {
            menuProvider = (ITileInventory)((Object)craft.getInventory());
        }
        if (menuProvider != null && menuProvider instanceof TileEntity && !(blockEntity = (TileEntity)((Object)menuProvider)).l()) {
            blockEntity.a(this.getHandle().dV());
        }
        if (menuProvider != null) {
            this.getHandle().a(menuProvider);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().a(horse.getHandle(), craft.getInventory());
        } else {
            Containers container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().bR == formerContainer) {
            return null;
        }
        this.getHandle().bR.checkReachable = false;
        return this.getHandle().bR.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, EntityPlayer player, Containers<?> windowType) {
        if (player.f == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        Container container = new CraftContainer(inventory, (EntityHuman)player, player.nextContainerCounter());
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        container = (Container)result.getSecond();
        if (container == null) {
            return;
        }
        Component adventure$title = container.getBukkitView().title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(container.getBukkitView().getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.fg()) {
            player.f.b(new PacketPlayOutOpenWindow(container.l, windowType, PaperAdventure.asVanilla(adventure$title)));
        }
        player.bR = container;
        player.a(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().a(Blocks.cL.m().b(this.getHandle().dV(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().bR.checkReachable = false;
        }
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        ITileInventory menuProvider = Blocks.fQ.m().b(this.getHandle().dV(), pos);
        if (menuProvider == null) {
            if (!force) {
                return null;
            }
            menuProvider = new TileInventory((syncId, inventory, player) -> new ContainerEnchantTable(syncId, inventory, ContainerAccess.a(this.getHandle().dV(), pos)), IChatBaseComponent.c("container.enchant"));
        }
        this.getHandle().a(menuProvider);
        if (force) {
            this.getHandle().bR.checkReachable = false;
        }
        return this.getHandle().bR.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        Container container;
        Preconditions.checkArgument((boolean)this.equals(inventory.getPlayer()), (Object)"InventoryView must belong to the opening player");
        if (!(this.getHandle() instanceof EntityPlayer)) {
            return;
        }
        if (((EntityPlayer)this.getHandle()).f == null) {
            return;
        }
        if (this.getHandle().bR != this.getHandle().bQ) {
            ((EntityPlayer)this.getHandle()).f.handleContainerClose(new PacketPlayInCloseWindow(this.getHandle().bR.l), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        EntityPlayer player = (EntityPlayer)this.getHandle();
        if (inventory instanceof CraftInventoryView) {
            container = ((CraftInventoryView)inventory).getHandle();
            Preconditions.checkArgument((!(container instanceof ContainerPlayer) ? 1 : 0) != 0, (Object)"Can not open player's InventoryView");
        } else {
            container = new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        }
        Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(player, container);
        container = (Container)result.getSecond();
        if (container == null) {
            return;
        }
        Containers windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        if (windowType == Containers.t) {
            CraftMenus.openMerchantMenu(player, (ContainerMerchant)container);
            return;
        }
        Component adventure$title = inventory.title();
        if (adventure$title == null) {
            adventure$title = LegacyComponentSerializer.legacySection().deserialize(inventory.getTitle());
        }
        if (result.getFirst() != null) {
            adventure$title = (Component)result.getFirst();
        }
        if (!player.fg()) {
            if (container instanceof ContainerHorse) {
                ContainerHorse horse = (ContainerHorse)container;
                player.f.b(new PacketPlayOutOpenWindowHorse(horse.l, horse.q.ab_(), horse.q.ao()));
            } else {
                player.f.b(new PacketPlayOutOpenWindow(container.l, windowType, PaperAdventure.asVanilla(adventure$title)));
            }
        }
        player.bR = container;
        player.a(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        IChatBaseComponent name;
        IMerchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().P_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().gF().c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.a(this.getHandle());
        mcMerchant.a(this.getHandle(), name, level);
        return this.getHandle().bR.getBukkitView();
    }

    public InventoryView openAnvil(Location location, boolean force) {
        return this.openInventory(location, force, Material.ANVIL);
    }

    public InventoryView openCartographyTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.CARTOGRAPHY_TABLE);
    }

    public InventoryView openGrindstone(Location location, boolean force) {
        return this.openInventory(location, force, Material.GRINDSTONE);
    }

    public InventoryView openLoom(Location location, boolean force) {
        return this.openInventory(location, force, Material.LOOM);
    }

    public InventoryView openSmithingTable(Location location, boolean force) {
        return this.openInventory(location, force, Material.SMITHING_TABLE);
    }

    public InventoryView openStonecutter(Location location, boolean force) {
        return this.openInventory(location, force, Material.STONECUTTER);
    }

    private InventoryView openInventory(Location location, boolean force, Material material) {
        Object block;
        AsyncCatcher.catchOp("open" + String.valueOf(material));
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != material) {
            return null;
        }
        if (material == Material.ANVIL) {
            block = Blocks.ht;
        } else if (material == Material.CARTOGRAPHY_TABLE) {
            block = Blocks.oD;
        } else if (material == Material.GRINDSTONE) {
            block = Blocks.oF;
        } else if (material == Material.LOOM) {
            block = Blocks.oz;
        } else if (material == Material.SMITHING_TABLE) {
            block = Blocks.oH;
        } else if (material == Material.STONECUTTER) {
            block = Blocks.oI;
        } else {
            throw new IllegalArgumentException("Unsupported inventory type: " + String.valueOf(material));
        }
        this.getHandle().a(block.b(null, this.getHandle().dV(), new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        this.getHandle().bR.checkReachable = !force;
        return this.getHandle().bR.getBukkitView();
    }

    public void closeInventory(InventoryCloseEvent.Reason reason) {
        this.getHandle().closeContainer(reason);
    }

    public boolean isBlocking() {
        return this.getHandle().fG();
    }

    public boolean isHandRaised() {
        return this.getHandle().fz();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().ci;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().ci = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().gt();
    }

    public float getAttackCooldown() {
        return this.getHandle().H(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.hasCooldown(new ItemStack(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getCooldown(new ItemStack(material));
    }

    public void setCooldown(Material material, int ticks) {
        this.setCooldown(new ItemStack(material), ticks);
    }

    public boolean hasCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        return this.getHandle().gG().a(CraftItemStack.asNMSCopy(item));
    }

    public int getCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        MinecraftKey group = this.getHandle().gG().b(CraftItemStack.asNMSCopy(item));
        if (group == null) {
            return 0;
        }
        ItemCooldown.Info cooldown = this.getHandle().gG().a.get(group);
        return cooldown == null ? 0 : Math.max(0, cooldown.b() - this.getHandle().gG().b);
    }

    public void setCooldown(ItemStack item, int ticks) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().gG().a(CraftItemStack.asNMSCopy(item), ticks);
    }

    public int getCooldown(Key key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        ItemCooldown.Info cooldown = this.getHandle().gG().a.get(PaperAdventure.asVanilla(key));
        return cooldown == null ? 0 : Math.max(0, cooldown.b() - this.getHandle().gG().b);
    }

    public void setCooldown(Key key, int ticks) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().gG().a(PaperAdventure.asVanilla(key), ticks);
    }

    public Entity releaseLeftShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().gC().j() && (entity = this.getHandle().releaseLeftShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public Entity releaseRightShoulderEntity() {
        net.minecraft.world.entity.Entity entity;
        if (!this.getHandle().gD().j() && (entity = this.getHandle().releaseRightShoulderEntity()) != null) {
            return entity.getBukkitEntity();
        }
        return null;
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<RecipeHolder<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        CraftingManager manager = this.getHandle().dV().p().aI();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<RecipeHolder<?>> recipe = manager.b(CraftRecipe.toMinecraft(recipeKey));
            if (recipe.isEmpty()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        if (!this.getHandle().gC().j()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().gC(), this.getHandle().dV(), EntitySpawnReason.r);
            return shoulder.map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        this.getHandle().k(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        if (!this.getHandle().gD().j()) {
            Optional<net.minecraft.world.entity.Entity> shoulder = EntityTypes.a(this.getHandle().gD(), this.getHandle().dV(), EntitySpawnReason.r);
            return shoulder.map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        this.getHandle().l(entity == null ? new NBTTagCompound() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public void openSign(Sign sign, Side side) {
        CraftSign.openSign(sign, (CraftPlayer)this, side);
    }

    public boolean dropItem(boolean dropAll) {
        EntityHuman entityHuman = this.getHandle();
        if (!(entityHuman instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityHuman;
        boolean success = player.a(dropAll);
        if (!success) {
            return false;
        }
        net.minecraft.world.entity.player.PlayerInventory inv = player.gj();
        OptionalInt optionalSlot = player.bR.b(inv, inv.f());
        optionalSlot.ifPresent(slot -> player.dm.a(player.bR, slot, inv.g()));
        return true;
    }

    @Nullable
    public Item dropItem(int slot, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        Preconditions.checkArgument((slot >= 0 && slot < this.inventory.getSize() ? 1 : 0) != 0, (String)"Slot %s is not a valid inventory slot.", (int)slot);
        return this.internalDropItemFromInventory(this.inventory.getItem(slot), amount, throwRandomly, entityOperation);
    }

    @Nullable
    public Item dropItem(@NotNull EquipmentSlot slot, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        return this.internalDropItemFromInventory(this.inventory.getItem(slot), amount, throwRandomly, entityOperation);
    }

    @Nullable
    private Item internalDropItemFromInventory(ItemStack originalItemStack, int amount, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        if (originalItemStack == null || originalItemStack.isEmpty() || amount <= 0) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.unwrap(originalItemStack);
        net.minecraft.world.item.ItemStack dropContent = nmsItemStack.a(amount);
        EntityItem droppedEntity = this.getHandle().drop(dropContent, throwRandomly, true, true, entityOperation);
        return droppedEntity == null ? null : (Item)droppedEntity.getBukkitEntity();
    }

    @Nullable
    public Item dropItem(ItemStack itemStack, boolean throwRandomly, @Nullable Consumer<Item> entityOperation) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Cannot drop a null itemstack");
        if (itemStack.isEmpty()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        EntityItem droppedEntity = this.getHandle().drop(nmsItemStack, throwRandomly, true, false, entityOperation);
        return droppedEntity == null ? null : (Item)droppedEntity.getBukkitEntity();
    }

    public float getExhaustion() {
        return this.getHandle().gu().e;
    }

    public void setExhaustion(float value) {
        this.getHandle().gu().e = value;
    }

    public float getSaturation() {
        return this.getHandle().gu().d;
    }

    public void setSaturation(float value) {
        this.getHandle().gu().d = value;
    }

    public int getFoodLevel() {
        return this.getHandle().gu().c;
    }

    public void setFoodLevel(int value) {
        this.getHandle().gu().c = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().gu().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().gu().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().gu().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().gu().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().gu().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().gu().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().gJ().map(CraftLocation::fromGlobalPos).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        this.getHandle().a(Optional.ofNullable(location).map(CraftLocation::toGlobalPos));
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        EntityFireworks fireworks = new EntityFireworks(this.getHandle().dV(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().dV().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public boolean canUseEquipmentSlot(EquipmentSlot slot) {
        EnumItemSlot equipmentSlot = CraftEquipmentSlot.getNMS(slot);
        return (equipmentSlot.a() == EnumItemSlot.Function.b || equipmentSlot.a() == EnumItemSlot.Function.a) && super.canUseEquipmentSlot(slot);
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

