/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)this.entity;
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().gH().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().a(EntityLlama.Variant.a(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().ca, this.getHandle().h(EnumItemSlot.g), this.getHandle().h(EnumItemSlot.h));
    }

    public int getStrength() {
        return this.getHandle().gy();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().gT();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    public boolean inCaravan() {
        return this.getHandle().he();
    }

    public void joinCaravan(@NotNull Llama llama) {
        this.getHandle().a(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().gJ();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().gK();
    }

    public Llama getCaravanHead() {
        return this.getHandle().hf() == null ? null : (Llama)this.getHandle().hf().getBukkitEntity();
    }

    public Llama getCaravanTail() {
        return this.getHandle().bP == null ? null : (Llama)this.getHandle().bP.getBukkitEntity();
    }
}

