/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.kyori.adventure.util.TriState;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.entity.Minecart;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public abstract class CraftMinecart
extends CraftVehicle
implements Minecart {
    public CraftMinecart(CraftServer server, EntityMinecartAbstract entity) {
        super(server, entity);
    }

    @Override
    public EntityMinecartAbstract getHandle() {
        return (EntityMinecartAbstract)this.entity;
    }

    public void setDamage(double damage) {
        this.getHandle().b((float)damage);
    }

    public double getDamage() {
        return this.getHandle().G();
    }

    public double getMaxSpeed() {
        return this.getHandle().f().b((WorldServer)this.getHandle().dV());
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public boolean isSlowWhenEmpty() {
        return this.getHandle().slowWhenEmpty;
    }

    public void setSlowWhenEmpty(boolean slow) {
        this.getHandle().slowWhenEmpty = slow;
    }

    public Vector getFlyingVelocityMod() {
        return this.getHandle().getFlyingVelocityMod();
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.getHandle().setFlyingVelocityMod(flying);
    }

    public Vector getDerailedVelocityMod() {
        return this.getHandle().getDerailedVelocityMod();
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.getHandle().setDerailedVelocityMod(derailed);
    }

    public Material getMinecartMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().p());
    }

    public void setDisplayBlock(MaterialData material) {
        this.getHandle().a(Optional.ofNullable(material).map(CraftMagicNumbers::getBlock));
    }

    public void setDisplayBlockData(BlockData blockData) {
        this.getHandle().a(Optional.ofNullable(blockData).map(data -> ((CraftBlockData)data).getState()));
    }

    public MaterialData getDisplayBlock() {
        IBlockData state = this.getHandle().n();
        return CraftMagicNumbers.getMaterial(state);
    }

    public BlockData getDisplayBlockData() {
        IBlockData state = this.getHandle().n();
        return CraftBlockData.fromData(state);
    }

    public void setDisplayBlockOffset(int offset) {
        this.getHandle().c(offset);
    }

    public int getDisplayBlockOffset() {
        return this.getHandle().w();
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state may not be null");
        this.getHandle().frictionState = state;
    }
}

