/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.util.Vector;

public class CraftShulkerBullet
extends AbstractProjectile
implements ShulkerBullet {
    public CraftShulkerBullet(CraftServer server, EntityShulkerBullet entity) {
        super(server, entity);
    }

    @Override
    public EntityShulkerBullet getHandle() {
        return (EntityShulkerBullet)this.entity;
    }

    public Entity getTarget() {
        return this.getHandle().getTarget() != null ? this.getHandle().getTarget().getBukkitEntity() : null;
    }

    public void setTarget(Entity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        this.getHandle().setTarget(target == null ? null : ((CraftEntity)target).getHandle());
    }

    public Vector getTargetDelta() {
        EntityShulkerBullet bullet = this.getHandle();
        return new Vector(bullet.e, bullet.f, bullet.g);
    }

    public void setTargetDelta(Vector vector) {
        EntityShulkerBullet bullet = this.getHandle();
        bullet.e = vector.getX();
        bullet.f = vector.getY();
        bullet.g = vector.getZ();
    }

    public BlockFace getCurrentMovementDirection() {
        EnumDirection dir = this.getHandle().c;
        if (dir == null) {
            return null;
        }
        return CraftBlock.notchToBlockFace(dir);
    }

    public void setCurrentMovementDirection(BlockFace movementDirection) {
        this.getHandle().c = CraftBlock.blockFaceToNotch(movementDirection);
    }

    public int getFlightSteps() {
        return this.getHandle().d;
    }

    public void setFlightSteps(int steps) {
        this.getHandle().d = steps;
    }
}

