/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAnimals;
import org.bukkit.entity.Strider;

public class CraftStrider
extends CraftAnimals
implements Strider {
    public CraftStrider(CraftServer server, EntityStrider entity) {
        super(server, entity);
    }

    @Override
    public EntityStrider getHandle() {
        return (EntityStrider)this.entity;
    }

    public boolean isShivering() {
        return this.getHandle().m();
    }

    public void setShivering(boolean shivering) {
        this.getHandle().w(shivering);
    }

    public boolean hasSaddle() {
        return this.getHandle().fZ();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().a(EnumItemSlot.h, saddled ? new ItemStack(Items.ou) : ItemStack.l);
    }

    public int getBoostTicks() {
        return this.getHandle().bP.e ? this.getHandle().bP.d() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().bP.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().bP.e ? this.getHandle().bP.f : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().bP.e) {
            return;
        }
        int max = this.getHandle().bP.d();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %s (inclusive)", (int)max);
        this.getHandle().bP.f = ticks;
    }

    public Material getSteerMaterial() {
        return Material.WARPED_FUNGUS_ON_A_STICK;
    }
}

