/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TNTPrimed;

public class CraftTNTPrimed
extends CraftEntity
implements TNTPrimed {
    public CraftTNTPrimed(CraftServer server, EntityTNTPrimed entity) {
        super(server, entity);
    }

    @Override
    public EntityTNTPrimed getHandle() {
        return (EntityTNTPrimed)this.entity;
    }

    public float getYield() {
        return this.getHandle().l;
    }

    public boolean isIncendiary() {
        return this.getHandle().isIncendiary;
    }

    public void setIsIncendiary(boolean isIncendiary) {
        this.getHandle().isIncendiary = isIncendiary;
    }

    public void setYield(float yield) {
        this.getHandle().l = yield;
    }

    public int getFuseTicks() {
        return this.getHandle().f();
    }

    public void setFuseTicks(int fuseTicks) {
        this.getHandle().b(fuseTicks);
    }

    public Entity getSource() {
        EntityLiving source = this.getHandle().e();
        return source != null ? source.getBukkitEntity() : null;
    }

    public void setSource(Entity source) {
        this.getHandle().j = source instanceof LivingEntity ? ((CraftLivingEntity)source).getHandle() : null;
    }

    public void setBlockData(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"The visual block data of this tnt cannot be null. To reset it just set to the TNT default block data");
        this.getHandle().c(((CraftBlockData)data).getState());
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().i());
    }
}

