/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftAbstractArrow;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;

public class CraftTrident
extends CraftAbstractArrow
implements Trident {
    public CraftTrident(CraftServer server, EntityThrownTrident entity) {
        super(server, entity);
    }

    @Override
    public EntityThrownTrident getHandle() {
        return (EntityThrownTrident)this.entity;
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().aA);
    }

    @Override
    public void setItem(ItemStack itemStack) {
        this.getHandle().aA = CraftItemStack.asNMSCopy(itemStack);
    }

    public boolean hasGlint() {
        return this.getHandle().x();
    }

    public void setGlint(boolean glint) {
        this.getHandle().setFoil(glint);
    }

    public int getLoyaltyLevel() {
        return this.getHandle().getLoyalty();
    }

    public void setLoyaltyLevel(int loyaltyLevel) {
        Preconditions.checkArgument((loyaltyLevel >= 0 && loyaltyLevel <= 127 ? 1 : 0) != 0, (Object)"The loyalty level has to be between 0 and 127");
        this.getHandle().setLoyalty((byte)loyaltyLevel);
    }

    public boolean hasDealtDamage() {
        return this.getHandle().i;
    }

    public void setHasDealtDamage(boolean hasDealtDamage) {
        this.getHandle().i = hasDealtDamage;
    }
}

