/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_21_R4.util.Handleable;
import org.bukkit.entity.Wolf;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, EntityWolf wolf) {
        super(server, wolf);
    }

    @Override
    public EntityWolf getHandle() {
        return (EntityWolf)this.entity;
    }

    public boolean isAngry() {
        return this.getHandle().ac_();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().c();
        } else {
            this.getHandle().i();
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gJ().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public boolean isWet() {
        return this.getHandle().bZ;
    }

    public float getTailAngle() {
        return this.getHandle().gI();
    }

    public boolean isInterested() {
        return this.getHandle().gK();
    }

    public void setInterested(boolean interested) {
        this.getHandle().z(interested);
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gL());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().j(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public Wolf.SoundVariant getSoundVariant() {
        return CraftSoundVariant.minecraftHolderToBukkit(this.getHandle().gM());
    }

    public void setSoundVariant(Wolf.SoundVariant soundVariant) {
        Preconditions.checkArgument((soundVariant != null ? 1 : 0) != 0, (Object)"soundVariant cannot be null");
        this.getHandle().k(CraftSoundVariant.bukkitToMinecraftHolder(soundVariant));
    }

    public static class CraftVariant
    implements Wolf.Variant,
    Handleable<WolfVariant> {
        private final NamespacedKey key;
        private final WolfVariant variant;

        public static Wolf.Variant minecraftToBukkit(WolfVariant minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.bm);
        }

        public static Wolf.Variant minecraftHolderToBukkit(Holder<WolfVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static WolfVariant bukkitToMinecraft(Wolf.Variant bukkit) {
            return (WolfVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfVariant> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry<WolfVariant> registry = CraftRegistry.getMinecraftRegistry(Registries.bm);
            Holder<WolfVariant> holder = registry.e(CraftVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf variant with out properly registering it.");
        }

        public CraftVariant(NamespacedKey key, WolfVariant variant) {
            this.key = key;
            this.variant = variant;
        }

        @Override
        public WolfVariant getHandle() {
            return this.variant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftVariant)) {
                return false;
            }
            CraftVariant otherVariant = (CraftVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }

    public static class CraftSoundVariant
    implements Wolf.SoundVariant,
    Handleable<WolfSoundVariant> {
        private final NamespacedKey key;
        private final WolfSoundVariant soundVariant;

        public static Wolf.SoundVariant minecraftToBukkit(WolfSoundVariant minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftToBukkit(minecraft, Registries.bn);
        }

        public static Wolf.SoundVariant minecraftHolderToBukkit(Holder<WolfSoundVariant> minecraft) {
            return CraftSoundVariant.minecraftToBukkit(minecraft.a());
        }

        public static WolfSoundVariant bukkitToMinecraft(Wolf.SoundVariant bukkit) {
            return (WolfSoundVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfSoundVariant> bukkitToMinecraftHolder(Wolf.SoundVariant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            IRegistry<WolfSoundVariant> registry = CraftRegistry.getMinecraftRegistry(Registries.bn);
            Holder<WolfSoundVariant> holder = registry.e(CraftSoundVariant.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.c) {
                Holder.c holder2 = (Holder.c)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf sound variant with out properly registering it.");
        }

        public CraftSoundVariant(NamespacedKey key, WolfSoundVariant soundVariant) {
            this.key = key;
            this.soundVariant = soundVariant;
        }

        @Override
        public WolfSoundVariant getHandle() {
            return this.soundVariant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftSoundVariant)) {
                return false;
            }
            CraftSoundVariant otherVariant = (CraftSoundVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

