/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.v1_21_R4.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.util.BlockVector;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    static final CraftMetaItem.ItemMetaKeyType<CustomData> BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.aa, "BlockEntityTag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_TAG_CUSTOM_DATA = new CraftMetaItem.ItemMetaKey("block-entity-tag");
    static final CraftMetaItem.ItemMetaKey BLOCK_ENTITY_COMPONENTS = new CraftMetaItem.ItemMetaKey("block-entity-components");
    final Material material;
    DataComponentMap components;
    CustomData blockEntityTag;
    private NBTTagCompound internalTag;

    private Material materialForBlockEntityType() {
        return this.material;
    }

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        CraftMetaBlockState metaBlockState;
        block3: {
            block2: {
                super(meta);
                this.components = this.components != null ? this.components : DataComponentMap.a;
                this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.a;
                this.material = material;
                if (!(meta instanceof CraftMetaBlockState)) break block2;
                metaBlockState = (CraftMetaBlockState)meta;
                if (metaBlockState.material == material) break block3;
            }
            this.components = DataComponentMap.a;
            this.blockEntityTag = CustomData.a;
            return;
        }
        this.components = metaBlockState.components;
        this.blockEntityTag = metaBlockState.blockEntityTag;
    }

    CraftMetaBlockState(DataComponentPatch tag, Material material, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        this.components = this.components != null ? this.components : DataComponentMap.a;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.a;
        this.material = material;
        this.updateBlockState(tag);
    }

    private void updateBlockState(DataComponentPatch tag) {
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(nbt -> {
            this.blockEntityTag = nbt;
        });
        if (!tag.d()) {
            DataComponentMap.a map = DataComponentMap.a();
            TileEntity dummyBlockEntity = Objects.requireNonNull(CraftBlockStates.createNewBlockEntity(this.materialForBlockEntityType()));
            Set<DataComponentType<?>> applied = dummyBlockEntity.applyComponentsSet(DataComponentMap.a, DataComponentPatch.a);
            for (DataComponentType<?> seen : applied) {
                this.unhandledTags.clear(seen);
            }
            if (!applied.isEmpty()) {
                for (DataComponentType<?> type : applied) {
                    if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(type)) continue;
                    CraftMetaBlockState.getOrEmpty(tag, type).ifPresent(value -> map.a(type, value));
                }
            }
            this.components = map.a();
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        BlockVector legacyPosition;
        this.components = this.components != null ? this.components : DataComponentMap.a;
        this.blockEntityTag = this.blockEntityTag != null ? this.blockEntityTag : CustomData.a;
        String blockMaterial = SerializableMeta.getString(map, "blockMaterial", true);
        Material material = Material.getMaterial((String)blockMaterial);
        Material material2 = this.material = material != null ? material : Material.AIR;
        if (this.internalTag != null) {
            this.setBlockState(CraftMetaBlockState.getBlockState(this.material, this.internalTag));
            this.internalTag = null;
        }
        if ((legacyPosition = SerializableMeta.getObject(BlockVector.class, map, "blockPosition", true)) != null) {
            this.blockEntityTag = this.blockEntityTag.a(blockEntityTag -> {
                if (blockEntityTag.j()) {
                    TileEntity.a(blockEntityTag, Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
                }
                blockEntityTag.a("x", legacyPosition.getBlockX());
                blockEntityTag.a("y", legacyPosition.getBlockY());
                blockEntityTag.a("z", legacyPosition.getBlockZ());
            });
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        NBTTagCompound nbt = this.blockEntityTag.d();
        if (!nbt.j()) {
            if (nbt.i("id").isEmpty()) {
                TileEntity.a(nbt, Objects.requireNonNull(CraftBlockStates.getBlockEntityType(this.materialForBlockEntityType())));
            }
            tag.put(BLOCK_ENTITY_TAG, CustomData.a(nbt));
        }
        for (TypedDataComponent<?> component : this.components) {
            if (CraftMetaItem.DEFAULT_HANDLED_DCTS.contains(component.a())) continue;
            tag.builder.a(component);
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        Optional<NBTTagCompound> blockEntityTag = tag.m(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT);
        if (blockEntityTag.isPresent()) {
            this.internalTag = blockEntityTag.get();
            return;
        }
        tag.m(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT).ifPresent(blockEntityCustomTag -> {
            this.blockEntityTag = CustomData.a(blockEntityCustomTag);
        });
        tag.m(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT).ifPresent(components -> {
            this.components = (DataComponentMap)DataComponentMap.b.parse(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), components).getOrThrow();
        });
    }

    @Override
    void serializeInternal(Map<String, NBTBase> internalTags) {
        if (!this.blockEntityTag.c()) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG_CUSTOM_DATA.NBT, this.blockEntityTag.e());
        }
        if (!this.components.e()) {
            NBTBase componentsTag = (NBTBase)DataComponentMap.b.encodeStart(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)this.components).getOrThrow();
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_COMPONENTS.NBT, componentsTag);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        hash = 61 * hash + this.blockEntityTag.hashCode();
        return original != (hash = 61 * hash + this.components.hashCode()) ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState other = (CraftMetaBlockState)meta;
            return Objects.equals(this.blockEntityTag, other.blockEntityTag) && Objects.equals(this.components, other.components);
        }
        return true;
    }

    boolean isBlockStateEmpty() {
        return this.blockEntityTag == null;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.blockEntityTag.c() && this.components.e());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.blockEntityTag.c() && this.components.e();
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        meta.blockEntityTag = this.blockEntityTag;
        meta.components = this.components;
        return meta;
    }

    public boolean hasBlockState() {
        return !this.blockEntityTag.c() || !this.components.e();
    }

    public void clearBlockState() {
        this.blockEntityTag = CustomData.a;
        this.components = DataComponentMap.a;
    }

    public CraftBlockEntityState<?> getBlockState() {
        BlockPosition pos = BlockPosition.c;
        Material stateMaterial = this.materialForBlockEntityType();
        if (!this.blockEntityTag.c()) {
            pos = TileEntity.a(null, this.blockEntityTag.e());
        }
        TileEntityTypes<?> type = Objects.requireNonNull(CraftBlockStates.getBlockEntityType(stateMaterial));
        IBlockData nmsBlockState = ((CraftBlockData)this.getBlockData(stateMaterial)).getState();
        TileEntity blockEntity = (TileEntity)Objects.requireNonNull(type.a(pos, nmsBlockState));
        if (!this.blockEntityTag.c()) {
            this.blockEntityTag.a(blockEntity, CraftRegistry.getMinecraftRegistry());
        }
        PatchedDataComponentMap patchedMap = new PatchedDataComponentMap(nmsBlockState.b().h().f());
        patchedMap.a(this.components);
        CraftMetaItem.Applicator applicator = new CraftMetaItem.Applicator(this){};
        super.applyToItem(applicator);
        patchedMap.a(applicator.build());
        blockEntity.a(nmsBlockState.b().h().f(), patchedMap.g());
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(null, pos, nmsBlockState, blockEntity);
    }

    private static CraftBlockEntityState<?> getBlockState(Material material, NBTTagCompound blockEntityTag) {
        Material stateMaterial;
        BlockPosition pos = BlockPosition.c;
        Material material2 = stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack(blockEntityTag);
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.a("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.a("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.a("id", "minecraft:shulker_box");
            }
            pos = TileEntity.a(null, blockEntityTag);
        }
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(CraftRegistry.getMinecraftRegistry(), pos, stateMaterial, blockEntityTag);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(null);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (String)"Invalid blockState for %s", (Object)this.material);
        CraftBlockEntityState craftBlockState = (CraftBlockEntityState)blockState;
        NBTTagCompound data = craftBlockState.getSnapshotCustomNbtOnly();
        PatchedDataComponentMap patchedMap = new PatchedDataComponentMap(craftBlockState.getHandle().b().h().f());
        DataComponentMap map = craftBlockState.collectComponents();
        patchedMap.a(map);
        if (!data.j()) {
            patchedMap.b(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CustomData.a(data));
        }
        DataComponentPatch patch = patchedMap.g();
        this.updateFromPatch(patch, null);
        this.blockEntityTag = CustomData.a;
        this.components = DataComponentMap.a;
        this.updateBlockState(patch);
    }

    private static Material shieldToBannerHack(NBTTagCompound tag) {
        Optional baseColor;
        if (tag != null && (baseColor = tag.m("components").flatMap(components -> components.i("minecraft:base_color"))).isPresent()) {
            DyeColor color = DyeColor.getByWoolData((byte)((byte)EnumColor.a((String)baseColor.get(), EnumColor.a).a()));
            return CraftMetaShield.shieldToBannerHack(color);
        }
        return Material.WHITE_BANNER;
    }
}

