/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory;

import com.destroystokyo.paper.Namespaced;
import com.destroystokyo.paper.NamespacedTag;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R4.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.Overridden;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaArmor;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaColorableArmor;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaOminousBottle;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_21_R4.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftCustomModelDataComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftFoodComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftJukeboxComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.v1_21_R4.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R4.tag.CraftDamageTag;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.VisibleForTesting;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final ItemMetaKeyType<IChatBaseComponent> NAME = new ItemMetaKeyType<IChatBaseComponent>(DataComponents.g, "display-name");
    static final ItemMetaKeyType<IChatBaseComponent> ITEM_NAME = new ItemMetaKeyType<IChatBaseComponent>(DataComponents.h, "item-name");
    static final ItemMetaKeyType<ItemLore> LORE = new ItemMetaKeyType<ItemLore>(DataComponents.j, "lore");
    static final ItemMetaKeyType<CustomModelData> CUSTOM_MODEL_DATA = new ItemMetaKeyType<CustomModelData>(DataComponents.p, "custom-model-data");
    static final ItemMetaKeyType<Enchantable> ENCHANTABLE = new ItemMetaKeyType<Enchantable>(DataComponents.C, "enchantable");
    static final ItemMetaKeyType<ItemEnchantments> ENCHANTMENTS = new ItemMetaKeyType<ItemEnchantments>(DataComponents.l, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType<Integer>(DataComponents.r, "repair-cost");
    static final ItemMetaKeyType<ItemAttributeModifiers> ATTRIBUTES = new ItemMetaKeyType<ItemAttributeModifiers>(DataComponents.o, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("ItemFlags");
    static final ItemMetaKeyType<TooltipDisplay> TOOLTIP_DISPLAY = new ItemMetaKeyType<TooltipDisplay>(DataComponents.q, "tool-tip-display");
    static final ItemMetaKeyType<MinecraftKey> TOOLTIP_STYLE = new ItemMetaKeyType<MinecraftKey>(DataComponents.G, "tool-tip-style");
    static final ItemMetaKeyType<MinecraftKey> ITEM_MODEL = new ItemMetaKeyType<MinecraftKey>(DataComponents.i, "item-model");
    static final ItemMetaKeyType<Unit> UNBREAKABLE = new ItemMetaKeyType<Unit>(DataComponents.f, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType<Boolean>(DataComponents.t, "enchantment-glint-override");
    static final ItemMetaKeyType<Unit> GLIDER = new ItemMetaKeyType<Unit>(DataComponents.F, "glider");
    static final ItemMetaKeyType<DamageResistant> DAMAGE_RESISTANT = new ItemMetaKeyType<DamageResistant>(DataComponents.z, "damage-resistant");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType<Integer>(DataComponents.c, "max-stack-size");
    static final ItemMetaKeyType<EnumItemRarity> RARITY = new ItemMetaKeyType<EnumItemRarity>(DataComponents.k, "rarity");
    static final ItemMetaKeyType<UseRemainder> USE_REMAINDER = new ItemMetaKeyType<UseRemainder>(DataComponents.x, "use-remainder");
    static final ItemMetaKeyType<UseCooldown> USE_COOLDOWN = new ItemMetaKeyType<UseCooldown>(DataComponents.y, "use-cooldown");
    static final ItemMetaKeyType<FoodInfo> FOOD = new ItemMetaKeyType<FoodInfo>(DataComponents.v, "food");
    static final ItemMetaKeyType<Tool> TOOL = new ItemMetaKeyType<Tool>(DataComponents.A, "tool");
    static final ItemMetaKeyType<Equippable> EQUIPPABLE = new ItemMetaKeyType<Equippable>(DataComponents.D, "equippable");
    static final ItemMetaKeyType<JukeboxPlayable> JUKEBOX_PLAYABLE = new ItemMetaKeyType<JukeboxPlayable>(DataComponents.ae, "jukebox-playable");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.e, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType<Integer>(DataComponents.d, "max-damage");
    static final ItemMetaKeyType<BlockItemStateProperties> BLOCK_DATA = new ItemMetaKeyType<BlockItemStateProperties>(DataComponents.aq, "BlockStateTag");
    static final ItemMetaKeyType<AdventureModePredicate> CAN_PLACE_ON = new ItemMetaKeyType<AdventureModePredicate>(DataComponents.m);
    static final ItemMetaKeyType<AdventureModePredicate> CAN_BREAK = new ItemMetaKeyType<AdventureModePredicate>(DataComponents.n);
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<CustomData> CUSTOM_DATA = new ItemMetaKeyType<CustomData>(DataComponents.b);
    private IChatBaseComponent displayName;
    private IChatBaseComponent itemName;
    private List<IChatBaseComponent> lore;
    private CraftCustomModelDataComponent customModelData;
    private Integer enchantableValue;
    private Map<String, String> blockData;
    private EnchantmentMap enchantments;
    private Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers;
    private int repairCost;
    @Nullable
    private TooltipDisplay tooltipDisplay;
    private NamespacedKey tooltipStyle;
    private NamespacedKey itemModel;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean glider;
    private TagKey<DamageType> damageResistant;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private ItemStack useRemainder;
    private CraftUseCooldownComponent useCooldown;
    private CraftFoodComponent food;
    private CraftToolComponent tool;
    private CraftEquippableComponent equippable;
    private CraftJukeboxComponent jukebox;
    private Integer damage;
    private Integer maxDamage;
    private List<CriterionConditionBlock> canPlaceOnPredicates;
    private List<CriterionConditionBlock> canBreakPredicates;
    private static final Set<DataComponentType<?>> HIDDEN_COMPONENTS_PREVIOUSLY = Set.of(DataComponents.am, DataComponents.ar, DataComponents.aa, DataComponents.aq, DataComponents.Q, DataComponents.P, DataComponents.ap, DataComponents.at, DataComponents.ai, DataComponents.aj, DataComponents.ab, DataComponents.M, DataComponents.aM, DataComponents.ao, DataComponents.R, DataComponents.aC, DataComponents.V);
    private static final Map<ItemFlag, Set<DataComponentType<?>>> ITEM_FLAG_EQUIVALENTS = ImmutableMap.builder().put((Object)ItemFlag.HIDE_ATTRIBUTES, Set.of(DataComponents.o)).put((Object)ItemFlag.HIDE_ENCHANTS, Set.of(DataComponents.l)).put((Object)ItemFlag.HIDE_STORED_ENCHANTS, Set.of(DataComponents.J)).put((Object)ItemFlag.HIDE_UNBREAKABLE, Set.of(DataComponents.f)).put((Object)ItemFlag.HIDE_DYE, Set.of(DataComponents.K)).put((Object)ItemFlag.HIDE_ARMOR_TRIM, Set.of(DataComponents.W)).put((Object)ItemFlag.HIDE_PLACED_ON, Set.of(DataComponents.m)).put((Object)ItemFlag.HIDE_DESTROYS, Set.of(DataComponents.n)).put((Object)ItemFlag.HIDE_ADDITIONAL_TOOLTIP, HIDDEN_COMPONENTS_PREVIOUSLY).buildOrThrow();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private NBTTagCompound customTag;
    protected DataComponentPatch.a unhandledTags = DataComponentPatch.a();
    private Set<DataComponentType<?>> removedTags = Sets.newHashSet();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();
    @VisibleForTesting
    public static final Map<Class<? extends CraftMetaItem>, Set<DataComponentType<?>>> HANDLED_DCTS_PER_TYPE = new HashMap();
    protected static final Set<DataComponentType<?>> DEFAULT_HANDLED_DCTS = Set.of(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.ENCHANTABLE.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.TOOLTIP_DISPLAY.TYPE, CraftMetaItem.TOOLTIP_STYLE.TYPE, CraftMetaItem.ITEM_MODEL.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.GLIDER.TYPE, CraftMetaItem.DAMAGE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.USE_REMAINDER.TYPE, CraftMetaItem.USE_COOLDOWN.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.EQUIPPABLE.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaItem.CAN_PLACE_ON.TYPE, CraftMetaItem.CAN_BREAK.TYPE);

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<IChatBaseComponent>(meta.lore);
        }
        if (meta.hasCustomModelDataComponent()) {
            this.customModelData = new CraftCustomModelDataComponent(meta.customModelData);
        }
        this.enchantableValue = meta.enchantableValue;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new EnchantmentMap(meta.enchantments);
        }
        if (meta.attributeModifiers != null) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        if (meta.tooltipDisplay != null) {
            this.tooltipDisplay = new TooltipDisplay(meta.tooltipDisplay.a(), (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet(meta.tooltipDisplay.b()));
        }
        this.tooltipStyle = meta.tooltipStyle;
        this.itemModel = meta.itemModel;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.glider = meta.glider;
        this.damageResistant = meta.damageResistant;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.hasUseRemainder()) {
            this.useRemainder = meta.useRemainder.clone();
        }
        if (meta.hasUseCooldown()) {
            this.useCooldown = new CraftUseCooldownComponent(meta.useCooldown);
        }
        if (meta.hasFood()) {
            this.food = new CraftFoodComponent(meta.food);
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasEquippable()) {
            this.equippable = new CraftEquippableComponent(meta.equippable);
        }
        if (meta.hasJukeboxPlayable()) {
            this.jukebox = new CraftJukeboxComponent(meta.jukebox);
        }
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.unhandledTags.copy(meta.unhandledTags.a());
        this.removedTags.addAll(meta.removedTags);
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getTagsCloned());
        this.canPlaceOnPredicates = meta.canPlaceOnPredicates;
        this.canBreakPredicates = meta.canBreakPredicates;
        this.customTag = meta.customTag;
        this.version = meta.version;
    }

    CraftMetaItem(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledTags) {
        this.updateFromPatch(tag, extraHandledTags);
    }

    protected final void updateFromPatch(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledTags) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l2 -> {
            this.lore = new ArrayList<IChatBaseComponent>(l2.a());
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i2 -> {
            this.customModelData = new CraftCustomModelDataComponent((CustomModelData)i2);
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTABLE).ifPresent(i2 -> {
            this.enchantableValue = i2.a();
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t2 -> {
            this.blockData = t2.b();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en);
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en);
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i2 -> {
            this.repairCost = i2;
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_DISPLAY).ifPresent(en -> {
            this.tooltipDisplay = new TooltipDisplay(en.a(), (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet(en.b()));
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_STYLE).ifPresent(key -> {
            this.tooltipStyle = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_MODEL).ifPresent(key -> {
            this.itemModel = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u2 -> {
            this.unbreakable = true;
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, GLIDER).ifPresent(u2 -> {
            this.glider = true;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_RESISTANT).ifPresent(tags -> {
            this.damageResistant = tags.a();
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i2 -> {
            this.maxStackSize = i2;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf((String)enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, USE_REMAINDER).ifPresent(remainder -> {
            this.useRemainder = CraftItemStack.asCraftMirror(remainder.a());
        });
        CraftMetaItem.getOrEmpty(tag, USE_COOLDOWN).ifPresent(cooldown -> {
            this.useCooldown = new CraftUseCooldownComponent((UseCooldown)cooldown);
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {
            this.food = new CraftFoodComponent((FoodInfo)foodInfo);
        });
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((Tool)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, EQUIPPABLE).ifPresent(equippableInfo -> {
            this.equippable = new CraftEquippableComponent((Equippable)equippableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, JUKEBOX_PLAYABLE).ifPresent(jukeboxPlayable -> {
            this.jukebox = new CraftJukeboxComponent((JukeboxPlayable)jukeboxPlayable);
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i2 -> {
            this.damage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i2 -> {
            this.maxDamage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.d();
            NBTTagCompound customDataTag = this.customTag.n(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            if (!customDataTag.j()) {
                for (Map.Entry<String, NBTBase> entry : customDataTag.g()) {
                    this.persistentDataContainer.put(entry.getKey(), entry.getValue().d());
                }
                this.customTag.r(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            }
            if (this.customTag.j()) {
                this.customTag = null;
            }
        });
        CraftMetaItem.getOrEmpty(tag, CraftMetaItem.CAN_PLACE_ON.TYPE).ifPresent(data -> {
            this.canPlaceOnPredicates = List.copyOf(data.f);
        });
        CraftMetaItem.getOrEmpty(tag, CAN_BREAK).ifPresent(data -> {
            this.canBreakPredicates = List.copyOf(data.f);
        });
        Set<DataComponentType<?>> handledTags = CraftMetaItem.getTopLevelHandledDcts(this.getClass());
        if (extraHandledTags != null) {
            extraHandledTags.addAll(handledTags);
            handledTags = extraHandledTags;
        }
        Set<Map.Entry<DataComponentType<?>, Optional<?>>> keys = tag.b();
        for (Map.Entry<DataComponentType<?>, Optional<?>> key2 : keys) {
            if (!handledTags.contains(key2.getKey())) {
                key2.getValue().ifPresent(value -> this.unhandledTags.a((DataComponentType)key2.getKey(), value));
            }
            if (!key2.getValue().isEmpty()) continue;
            this.removedTags.add(key2.getKey());
        }
    }

    static EnchantmentMap buildEnchantments(ItemEnchantments tag) {
        EnchantmentMap enchantments = new EnchantmentMap();
        tag.b().forEach(entry -> {
            Holder id = (Holder)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(ItemAttributeModifiers tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List<ItemAttributeModifiers.b> mods = tag.b();
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            ItemAttributeModifiers.b entry = mods.get(i2);
            AttributeModifier nmsModifier = entry.b();
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.a());
            if (attribute == null) continue;
            EquipmentSlotGroup slotName = entry.c();
            org.bukkit.inventory.EquipmentSlotGroup slot = null;
            try {
                slot = CraftEquipmentSlot.getSlotGroup(slotName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (slot == null) {
                modifiers.put((Object)attribute, (Object)attribMod);
                continue;
            }
            attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        Iterable removed;
        String unhandled;
        String internal;
        Integer maxDamage;
        Integer damage;
        CraftJukeboxComponent jukeboxPlayable;
        CraftEquippableComponent equippable;
        CraftToolComponent tool;
        CraftFoodComponent food;
        CraftUseCooldownComponent cooldown;
        ItemStack remainder;
        String rarity;
        Integer maxStackSize;
        Tag tag;
        String damageResistant;
        Boolean glider;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        String itemModel;
        String string;
        Iterable hideFlags;
        Object blockData;
        Object customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<IChatBaseComponent>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) instanceof CustomModelDataComponent) {
            CustomModelDataComponent component = (CustomModelDataComponent)customModelData;
            this.setCustomModelDataComponent(component);
        } else {
            this.setCustomModelData((Integer)customModelData);
        }
        Integer enchantmentValue = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.ENCHANTABLE.BUKKIT, true);
        if (enchantmentValue != null) {
            this.setEnchantable(enchantmentValue);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            if (blockData instanceof Map) {
                for (Map.Entry entry : ((Map)blockData).entrySet()) {
                    mapBlockData.put(entry.getKey().toString(), entry.getValue().toString());
                }
            } else {
                NBTTagCompound blockDataTag = (NBTTagCompound)CraftNBTTagConfigSerializer.deserialize(blockData);
                for (String key : blockDataTag.e()) {
                    mapBlockData.put(key, blockDataTag.i(key).orElseThrow());
                }
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                String hideFlagString = (String)hideFlagObject;
                try {
                    ItemFlag hideFlatEnum = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum);
                }
                catch (IllegalArgumentException hideFlatEnum) {}
            }
        }
        if ((string = SerializableMeta.getString(map, CraftMetaItem.TOOLTIP_STYLE.BUKKIT, true)) != null) {
            this.setTooltipStyle(NamespacedKey.fromString((String)string));
        }
        if ((itemModel = SerializableMeta.getString(map, CraftMetaItem.ITEM_MODEL.BUKKIT, true)) != null) {
            this.setItemModel(NamespacedKey.fromString((String)itemModel));
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((glider = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.GLIDER.BUKKIT, true)) != null) {
            this.setGlider(glider);
        }
        if ((damageResistant = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, true)) != null && (tag = Bukkit.getTag((String)"damage_types", (NamespacedKey)NamespacedKey.fromString((String)damageResistant), org.bukkit.damage.DamageType.class)) != null) {
            this.setDamageResistant((Tag<org.bukkit.damage.DamageType>)tag);
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf((String)rarity));
        }
        if ((remainder = SerializableMeta.getObject(ItemStack.class, map, CraftMetaItem.USE_REMAINDER.BUKKIT, true)) != null) {
            this.setUseRemainder(remainder);
        }
        if ((cooldown = SerializableMeta.getObject(CraftUseCooldownComponent.class, map, CraftMetaItem.USE_COOLDOWN.BUKKIT, true)) != null) {
            this.setUseCooldown(cooldown);
        }
        if ((food = SerializableMeta.getObject(CraftFoodComponent.class, map, CraftMetaItem.FOOD.BUKKIT, true)) != null) {
            this.setFood(food);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((equippable = SerializableMeta.getObject(CraftEquippableComponent.class, map, CraftMetaItem.EQUIPPABLE.BUKKIT, true)) != null) {
            this.setEquippable(equippable);
        }
        if ((jukeboxPlayable = SerializableMeta.getObject(CraftJukeboxComponent.class, map, CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, true)) != null) {
            this.setJukeboxPlayable(jukeboxPlayable);
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                NBTTagCompound internalTag = NBTCompressedStreamTools.a(buf, NBTReadLimiter.a());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(unhandled));
            try {
                NBTTagCompound unhandledTag = NBTCompressedStreamTools.a(buf, NBTReadLimiter.a());
                DataComponentPatch unhandledPatch = (DataComponentPatch)DataComponentPatch.b.parse(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)unhandledTag).result().get();
                CraftMetaItem.getOrEmpty(unhandledPatch, CAN_PLACE_ON).ifPresent(data -> {
                    this.canPlaceOnPredicates = List.copyOf(data.f);
                });
                CraftMetaItem.getOrEmpty(unhandledPatch, CAN_BREAK).ifPresent(data -> {
                    this.canBreakPredicates = List.copyOf(data.f);
                });
                this.unhandledTags.copy(unhandledPatch.a(type -> type == CraftMetaItem.CAN_PLACE_ON.TYPE || type == CraftMetaItem.CAN_BREAK.TYPE));
                for (Map.Entry entry : unhandledPatch.b()) {
                    if (!((Optional)entry.getValue()).isEmpty()) continue;
                    DataComponentType key = (DataComponentType)entry.getKey();
                    this.unhandledTags.clear(key);
                    this.removedTags.add(key);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((removed = SerializableMeta.getObject(Iterable.class, map, "removed", true)) != null) {
            IRegistryCustom registryAccess = CraftRegistry.getMinecraftRegistry();
            IRegistry<DataComponentType<?>> componentTypeRegistry = registryAccess.f(Registries.r);
            for (Object t2 : removed) {
                String removedString = (String)t2;
                DataComponentType<?> component = componentTypeRegistry.a(MinecraftKey.a(removedString));
                if (component == null) continue;
                this.removedTags.add(component);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((NBTTagCompound)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = NBTCompressedStreamTools.a(buf, NBTReadLimiter.a());
            }
            catch (IOException iOException) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    void deserializeInternal(NBTTagCompound tag, Object context) {
        if (tag.o(CraftMetaItem.ATTRIBUTES.NBT).isPresent()) {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        }
    }

    private static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiersLegacy(NBTTagCompound tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        NBTTagList mods = tag.p(key.NBT);
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute;
            AttributeModifier nmsModifier;
            NBTTagCompound entry = mods.b(i2);
            if (entry.j() || (nmsModifier = (AttributeModifier)AttributeModifier.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)entry).resultOrPartial().orElse(null)) == null) continue;
            org.bukkit.attribute.AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = entry.i(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT).map(CraftAttributeMap::convertIfNeeded).orElse(null);
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            Optional<String> attributeSlot = entry.i(CraftMetaItem.ATTRIBUTES_SLOT.NBT);
            if (attributeSlot.isPresent()) {
                String slotName = attributeSlot.get();
                if (slotName.isEmpty()) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlot slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(EnumItemSlot.a(slotName.toLowerCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new org.bukkit.attribute.AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static EnchantmentMap buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        EnchantmentMap enchantments = new EnchantmentMap();
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = CraftEnchantment.stringToBukkit(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static Multimap<Attribute, org.bukkit.attribute.AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return null;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o2 : list) {
                if (!(o2 instanceof org.bukkit.attribute.AttributeModifier)) continue;
                org.bukkit.attribute.AttributeModifier modifier = (org.bukkit.attribute.AttributeModifier)o2;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    @Overridden
    void applyToItem(Applicator tag) {
        NBTTagCompound customTag;
        if (this.hasDisplayName()) {
            tag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            tag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            tag.put(LORE, new ItemLore(this.lore));
        }
        if (this.hasCustomModelDataComponent()) {
            tag.put(CUSTOM_MODEL_DATA, this.customModelData.getHandle());
        }
        if (this.hasEnchantable()) {
            tag.put(ENCHANTABLE, new Enchantable(this.enchantableValue));
        }
        if (this.hasBlockData()) {
            tag.put(BLOCK_DATA, new BlockItemStateProperties(this.blockData));
        }
        this.applyEnchantments(this.enchantments, tag, ENCHANTMENTS);
        this.applyModifiers(this.attributeModifiers, tag);
        if (this.hasRepairCost()) {
            tag.put(REPAIR, this.repairCost);
        }
        if (this.tooltipDisplay != null) {
            tag.put(TOOLTIP_DISPLAY, new TooltipDisplay(this.tooltipDisplay.a(), (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet(this.tooltipDisplay.b())));
        }
        if (this.hasTooltipStyle()) {
            tag.put(TOOLTIP_STYLE, CraftNamespacedKey.toMinecraft(this.getTooltipStyle()));
        }
        if (this.hasItemModel()) {
            tag.put(ITEM_MODEL, CraftNamespacedKey.toMinecraft(this.getItemModel()));
        }
        if (this.isUnbreakable()) {
            tag.put(UNBREAKABLE, Unit.a);
        }
        if (this.hasEnchantmentGlintOverride()) {
            tag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isGlider()) {
            tag.put(GLIDER, Unit.a);
        }
        if (this.hasDamageResistant()) {
            tag.put(DAMAGE_RESISTANT, new DamageResistant(this.damageResistant));
        }
        if (this.hasMaxStackSize()) {
            tag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            tag.put(RARITY, EnumItemRarity.valueOf(this.rarity.name()));
        }
        if (this.hasUseRemainder()) {
            tag.put(USE_REMAINDER, new UseRemainder(CraftItemStack.asNMSCopy(this.useRemainder)));
        }
        if (this.hasUseCooldown()) {
            tag.put(USE_COOLDOWN, this.useCooldown.getHandle());
        }
        if (this.hasFood()) {
            tag.put(FOOD, this.food.getHandle());
        }
        if (this.hasTool()) {
            tag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasEquippable()) {
            tag.put(EQUIPPABLE, this.equippable.getHandle());
        }
        if (this.hasJukeboxPlayable()) {
            tag.put(JUKEBOX_PLAYABLE, this.jukebox.getHandle());
        }
        if (this.hasDamageValue()) {
            tag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            tag.put(MAX_DAMAGE, this.maxDamage);
        }
        if (this.canPlaceOnPredicates != null && !this.canPlaceOnPredicates.isEmpty()) {
            tag.put(CAN_PLACE_ON, new AdventureModePredicate(this.canPlaceOnPredicates));
        }
        if (this.canBreakPredicates != null && !this.canBreakPredicates.isEmpty()) {
            tag.put(CAN_BREAK, new AdventureModePredicate(this.canBreakPredicates));
        }
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : this.unhandledTags.a().b()) {
            entry.getValue().ifPresent(value -> tag.builder.a((DataComponentType)e2.getKey(), value));
        }
        for (DataComponentType dataComponentType : this.removedTags) {
            if (tag.builder.isSet(dataComponentType)) continue;
            tag.builder.a(dataComponentType);
        }
        NBTTagCompound nBTTagCompound = customTag = this.customTag != null ? this.customTag.l() : null;
        if (!this.persistentDataContainer.isEmpty()) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            Map<String, NBTBase> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, NBTBase> entry : rawPublicMap.entrySet()) {
                nBTTagCompound2.a(entry.getKey(), entry.getValue());
            }
            if (customTag == null) {
                customTag = new NBTTagCompound();
            }
            customTag.a(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, nBTTagCompound2);
        }
        if (customTag != null) {
            tag.put(CUSTOM_DATA, CustomData.a(customTag));
        }
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<ItemEnchantments> key) {
        if (enchantments == null) {
            return;
        }
        ItemEnchantments.a list = new ItemEnchantments.a(ItemEnchantments.a);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            list.a(CraftEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue());
        }
        tag.put(key, list.b());
    }

    void applyModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null) {
            return;
        }
        ItemAttributeModifiers.a list = ItemAttributeModifiers.a();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            AttributeModifier nmsModifier = CraftAttributeInstance.convert((org.bukkit.attribute.AttributeModifier)entry.getValue());
            Holder<AttributeBase> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            EquipmentSlotGroup group = CraftEquipmentSlot.getNMSGroup(((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup());
            list.a(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.a());
    }

    boolean applicableTo(Material type) {
        if (type == Material.AIR || !type.isItem()) {
            return false;
        }
        if (this.getClass() == CraftMetaItem.class) {
            return true;
        }
        return type.asItemType().getItemMetaClass() == this.getClass().getInterfaces()[0];
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelDataComponent() && !this.hasEnchantable() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.a().d() && this.removedTags.isEmpty() && this.persistentDataContainer.isEmpty() && !this.hasAnyItemFlag() && !this.isHideTooltip() && !this.hasTooltipStyle() && !this.hasItemModel() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isGlider() && !this.hasDamageResistant() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasUseRemainder() && !this.hasUseCooldown() && !this.hasFood() && !this.hasTool() && !this.hasJukeboxPlayable() && !this.hasEquippable() && !this.hasDamageValue() && !this.hasMaxDamage() && !this.hasAttributeModifiers() && this.customTag == null && this.canPlaceOnPredicates == null && this.canBreakPredicates == null;
    }

    public Component customName() {
        return this.displayName == null ? null : PaperAdventure.asAdventure(this.displayName);
    }

    public void customName(Component customName) {
        this.displayName = customName == null ? null : PaperAdventure.asVanilla(customName);
    }

    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName);
    }

    public BaseComponent[] getDisplayNameComponent() {
        return this.displayName == null ? new BaseComponent[]{} : CraftChatMessage.vanillaToBungee(this.displayName);
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.fromStringOrNull(name);
    }

    public void setDisplayNameComponent(BaseComponent[] component) {
        this.displayName = CraftChatMessage.bungeeToVanilla(component);
    }

    public boolean hasCustomName() {
        return this.displayName != null;
    }

    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    public final void setItemName(String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    public Component itemName() {
        return PaperAdventure.asAdventure(this.itemName);
    }

    public void itemName(Component name) {
        this.itemName = PaperAdventure.asVanilla(name);
    }

    public String getLocalizedName() {
        return this.getDisplayName();
    }

    public void setLocalizedName(String name) {
    }

    public boolean hasLocalizedName() {
        return false;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<Component> lore() {
        return this.lore != null ? PaperAdventure.asAdventure(this.lore) : null;
    }

    public void lore(List<? extends Component> lore) {
        if (lore == null) {
            this.lore = null;
            return;
        }
        Preconditions.checkArgument((lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        for (int i2 = 0; i2 < lore.size(); ++i2) {
            Preconditions.checkArgument((lore.get(i2) != null ? 1 : 0) != 0, (String)"lore contains null entry at index: %s", (int)i2);
        }
        this.lore = PaperAdventure.asVanilla(lore);
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment enchant) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        return this.hasEnchants() && this.enchantments.containsKey(enchant);
    }

    public int getEnchantLevel(Enchantment enchant) {
        Integer level;
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        Integer n2 = level = this.hasEnchants() ? (Integer)this.enchantments.get(enchant) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableSortedMap.copyOfSorted((SortedMap)this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment enchant, int level, boolean ignoreRestrictions) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.enchantments == null) {
            this.enchantments = new EnchantmentMap();
        }
        if (ignoreRestrictions || level >= enchant.getStartLevel() && level <= enchant.getMaxLevel()) {
            Integer old = this.enchantments.put(enchant, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment enchant) {
        boolean enchantmentRemoved;
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        boolean bl = enchantmentRemoved = this.hasEnchants() && this.enchantments.remove(enchant) != null;
        if (enchantmentRemoved && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return enchantmentRemoved;
    }

    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments = null;
        }
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment enchant) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, enchant);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        if (this.tooltipDisplay == null) {
            this.tooltipDisplay = new TooltipDisplay(false, (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet());
        }
        for (ItemFlag f2 : hideFlags) {
            this.tooltipDisplay.b().addAll((Collection)ITEM_FLAG_EQUIVALENTS.get(f2));
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        if (this.tooltipDisplay == null) {
            return;
        }
        for (ItemFlag f2 : hideFlags) {
            Set<DataComponentType<?>> dataComponentTypes = ITEM_FLAG_EQUIVALENTS.get(f2);
            if (!this.tooltipDisplay.b().containsAll(dataComponentTypes)) continue;
            this.tooltipDisplay.b().removeAll(dataComponentTypes);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f2 : ItemFlag.values()) {
            if (!this.hasItemFlag(f2)) continue;
            currentFlags.add(f2);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        if (this.tooltipDisplay == null) {
            return false;
        }
        return this.tooltipDisplay.b().containsAll((Collection)ITEM_FLAG_EQUIVALENTS.get(flag));
    }

    private boolean hasAnyItemFlag() {
        return this.tooltipDisplay != null && !this.tooltipDisplay.b().isEmpty();
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::fromComponent));
    }

    public List<BaseComponent[]> getLoreComponents() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, CraftChatMessage::vanillaToBungee));
    }

    public void setLore(List<String> lore) {
        Preconditions.checkArgument((lore == null || lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        if (lore == null || lore.isEmpty()) {
            this.lore = null;
        } else {
            if (this.lore == null) {
                this.lore = new ArrayList<IChatBaseComponent>(lore.size());
            } else {
                this.lore.clear();
            }
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public void setLoreComponents(List<BaseComponent[]> lore) {
        Preconditions.checkArgument((lore == null || lore.size() <= 256 ? 1 : 0) != 0, (String)"lore cannot have more than %s lines", (int)256);
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<IChatBaseComponent>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, false);
        }
    }

    public boolean hasCustomModelData() {
        if (this.customModelData != null) {
            List<Float> floats = this.customModelData.getFloats();
            return !floats.isEmpty();
        }
        return false;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        return this.customModelData.getFloats().get(0).intValue();
    }

    public boolean hasCustomModelDataComponent() {
        return this.customModelData != null;
    }

    public CustomModelDataComponent getCustomModelDataComponent() {
        return this.hasCustomModelDataComponent() ? new CraftCustomModelDataComponent(this.customModelData) : new CraftCustomModelDataComponent(new CustomModelData(List.of(), List.of(), List.of(), List.of()));
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data == null ? null : new CraftCustomModelDataComponent(new CustomModelData(List.of(Float.valueOf(data.floatValue())), List.of(), List.of(), List.of()));
    }

    public void setCustomModelDataComponent(CustomModelDataComponent customModelData) {
        this.customModelData = customModelData == null ? null : new CraftCustomModelDataComponent((CraftCustomModelDataComponent)customModelData);
    }

    public boolean hasEnchantable() {
        return this.enchantableValue != null;
    }

    public int getEnchantable() {
        Preconditions.checkState((boolean)this.hasEnchantable(), (Object)"We don't have Enchantable! Check hasEnchantable first!");
        return this.enchantableValue;
    }

    public void setEnchantable(Integer data) {
        Preconditions.checkArgument((data == null || data > 0 ? 1 : 0) != 0, (Object)"Enchantability must be positive");
        this.enchantableValue = data;
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        IBlockData defaultData = CraftBlockType.bukkitToMinecraft(material).m();
        return CraftBlockData.fromData(this.hasBlockData() ? new BlockItemStateProperties(this.blockData).a(defaultData) : defaultData);
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates(true);
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isHideTooltip() {
        return this.tooltipDisplay != null && this.tooltipDisplay.a();
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.tooltipDisplay = this.tooltipDisplay == null ? new TooltipDisplay(hideTooltip, (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet()) : new TooltipDisplay(hideTooltip, this.tooltipDisplay.b());
    }

    public boolean hasTooltipStyle() {
        return this.tooltipStyle != null;
    }

    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public boolean hasItemModel() {
        return this.itemModel != null;
    }

    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"We don't have enchantment_glint_override! Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    public boolean isGlider() {
        return this.glider;
    }

    public void setGlider(boolean glider) {
        this.glider = glider;
    }

    public boolean isFireResistant() {
        return this.hasDamageResistant() && this.damageResistant == DamageTypeTags.i;
    }

    public void setFireResistant(boolean fireResistant) {
        this.damageResistant = DamageTypeTags.i;
    }

    public boolean hasDamageResistant() {
        return this.damageResistant != null;
    }

    public Tag<org.bukkit.damage.DamageType> getDamageResistant() {
        return this.hasDamageResistant() ? Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(this.damageResistant.b()), org.bukkit.damage.DamageType.class) : null;
    }

    public void setDamageResistant(Tag<org.bukkit.damage.DamageType> tag) {
        this.damageResistant = tag != null ? ((CraftDamageTag)tag).getHandle().h() : null;
    }

    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    public int getMaxStackSize() {
        Preconditions.checkState((boolean)this.hasMaxStackSize(), (Object)"We don't have max_stack_size! Check hasMaxStackSize first!");
        return this.maxStackSize;
    }

    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    public boolean hasUseRemainder() {
        return this.useRemainder != null;
    }

    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public void setUseRemainder(ItemStack useRemainder) {
        Preconditions.checkArgument((useRemainder == null || !useRemainder.isEmpty() ? 1 : 0) != 0, (Object)"Item cannot be empty");
        this.useRemainder = useRemainder;
    }

    public boolean hasUseCooldown() {
        return this.useCooldown != null;
    }

    public UseCooldownComponent getUseCooldown() {
        return this.hasUseCooldown() ? new CraftUseCooldownComponent(this.useCooldown) : new CraftUseCooldownComponent(new UseCooldown(1.0f));
    }

    public void setUseCooldown(UseCooldownComponent cooldown) {
        this.useCooldown = cooldown == null ? null : new CraftUseCooldownComponent((CraftUseCooldownComponent)cooldown);
    }

    public boolean hasFood() {
        return this.food != null;
    }

    public FoodComponent getFood() {
        return this.hasFood() ? new CraftFoodComponent(this.food) : new CraftFoodComponent(new FoodInfo(0, 0.0f, false));
    }

    public void setFood(FoodComponent food) {
        this.food = food == null ? null : new CraftFoodComponent((CraftFoodComponent)food);
    }

    public boolean hasTool() {
        return this.tool != null;
    }

    public ToolComponent getTool() {
        return this.hasTool() ? new CraftToolComponent(this.tool) : new CraftToolComponent(new Tool(Collections.emptyList(), 1.0f, 0, true));
    }

    public void setTool(ToolComponent tool) {
        this.tool = tool == null ? null : new CraftToolComponent((CraftToolComponent)tool);
    }

    public boolean hasEquippable() {
        return this.equippable != null;
    }

    public EquippableComponent getEquippable() {
        return this.hasEquippable() ? new CraftEquippableComponent(this.equippable) : new CraftEquippableComponent(Equippable.a(EnumItemSlot.f).a());
    }

    public void setEquippable(EquippableComponent equippable) {
        this.equippable = equippable == null ? null : new CraftEquippableComponent((CraftEquippableComponent)equippable);
    }

    public boolean hasJukeboxPlayable() {
        return this.jukebox != null;
    }

    public JukeboxPlayableComponent getJukeboxPlayable() {
        return this.hasJukeboxPlayable() ? new CraftJukeboxComponent(this.jukebox) : new CraftJukeboxComponent(new JukeboxPlayable(new EitherHolder<JukeboxSong>(JukeboxSongs.a)));
    }

    public void setJukeboxPlayable(JukeboxPlayableComponent jukeboxPlayable) {
        this.jukebox = jukeboxPlayable == null ? null : new CraftJukeboxComponent((CraftJukeboxComponent)jukeboxPlayable);
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nullable EquipmentSlot slot) {
        if (this.attributeModifiers == null) {
            return LinkedHashMultimap.create();
        }
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup().test(slot)) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<org.bukkit.attribute.AttributeModifier> getAttributeModifiers(@Nonnull Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"Attribute cannot be null");
        if (this.attributeModifiers == null) {
            return null;
        }
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"Attribute cannot be null");
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"AttributeModifier cannot be null");
        if (this.attributeModifiers != null) {
            for (Map.Entry entry : this.attributeModifiers.entries()) {
                Preconditions.checkArgument((!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey()) || entry.getKey() != attribute ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
            }
        }
        this.checkAttributeList();
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(@Nullable Multimap<Attribute, org.bukkit.attribute.AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null) {
            this.attributeModifiers = null;
            return;
        }
        if (attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        if (this.attributeModifiers != null) {
            this.attributeModifiers.clear();
        }
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.checkAttributeList();
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((org.bukkit.attribute.AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"Attribute cannot be null");
        if (this.attributeModifiers == null) {
            return false;
        }
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(@Nonnull EquipmentSlot slot) {
        if (this.attributeModifiers == null) {
            return false;
        }
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!((org.bukkit.attribute.AttributeModifier)entry.getValue()).getSlotGroup().test(slot)) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(@Nonnull Attribute attribute, @Nonnull org.bukkit.attribute.AttributeModifier modifier) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"Attribute cannot be null");
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"AttributeModifier cannot be null");
        if (this.attributeModifiers == null) {
            return false;
        }
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((org.bukkit.attribute.AttributeModifier)entry.getValue()).getKey().equals((Object)modifier.getKey())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public String getAsString() {
        Applicator tag = new Applicator(this){};
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        NBTBase nbt = (NBTBase)DataComponentPatch.b.encodeStart(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)patch).getOrThrow();
        return nbt.toString();
    }

    public String getAsComponentString() {
        Applicator tag = new Applicator(this){};
        this.applyToItem(tag);
        DataComponentPatch patch = tag.build();
        IRegistryCustom registryAccess = CraftRegistry.getMinecraftRegistry();
        RegistryOps<NBTBase> ops = registryAccess.a(DynamicOpsNBT.a);
        IRegistry<DataComponentType<?>> componentTypeRegistry = registryAccess.f(Registries.r);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry<DataComponentType<?>, Optional<?>> entry : patch.b()) {
            DataComponentType<?> componentType = entry.getKey();
            Optional<?> componentValue = entry.getValue();
            String componentKey = componentTypeRegistry.d(componentType).orElseThrow().a().toString();
            if (componentValue.isPresent()) {
                NBTBase componentValueAsNBT = (NBTBase)componentType.c().encodeStart(ops, componentValue.get()).getOrThrow();
                String componentValueAsNBTString = new SnbtPrinterTagVisitor("", 0, new ArrayList<String>()).a(componentValueAsNBT);
                componentString.add(componentKey + "=" + componentValueAsNBTString);
                continue;
            }
            componentString.add("!" + componentKey);
        }
        return componentString.toString();
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> first, Multimap<Attribute, org.bukkit.attribute.AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage != null && this.damage > 0;
    }

    public int getDamage() {
        return this.damage == null ? 0 : this.damage;
    }

    public void setDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (Object)"Damage cannot be negative");
        Preconditions.checkArgument((!this.hasMaxDamage() || damage <= this.maxDamage ? 1 : 0) != 0, (Object)"Damage cannot exceed max damage");
        this.damage = damage;
    }

    public boolean hasDamageValue() {
        return this.damage != null;
    }

    public void resetDamage() {
        this.damage = null;
    }

    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    public void setMaxDamage(Integer maxDamage) {
        Preconditions.checkArgument((maxDamage == null || maxDamage > 0 ? 1 : 0) != 0, (Object)"Max damage should be positive");
        this.maxDamage = maxDamage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem meta) {
        return (this.hasDisplayName() ? meta.hasDisplayName() && this.displayName.equals(meta.displayName) : !meta.hasDisplayName()) && (this.hasItemName() ? meta.hasItemName() && this.itemName.equals(meta.itemName) : !meta.hasItemName()) && (this.hasEnchants() ? meta.hasEnchants() && this.enchantments.equals(meta.enchantments) : !meta.hasEnchants()) && Objects.equals(this.lore, meta.lore) && (this.hasCustomModelDataComponent() ? meta.hasCustomModelDataComponent() && this.customModelData.equals(meta.customModelData) : !meta.hasCustomModelDataComponent()) && (this.hasEnchantable() ? meta.hasEnchantable() && this.enchantableValue.equals(meta.enchantableValue) : !meta.hasEnchantable()) && (this.hasBlockData() ? meta.hasBlockData() && this.blockData.equals(meta.blockData) : !meta.hasBlockData()) && (this.hasRepairCost() ? meta.hasRepairCost() && this.repairCost == meta.repairCost : !meta.hasRepairCost()) && (this.attributeModifiers != null ? meta.attributeModifiers != null && CraftMetaItem.compareModifiers(this.attributeModifiers, meta.attributeModifiers) : meta.attributeModifiers == null) && this.unhandledTags.equals(meta.unhandledTags) && this.removedTags.equals(meta.removedTags) && Objects.equals(this.customTag, meta.customTag) && this.persistentDataContainer.equals(meta.persistentDataContainer) && Objects.equals(this.tooltipDisplay, meta.tooltipDisplay) && this.isHideTooltip() == meta.isHideTooltip() && (this.hasTooltipStyle() ? meta.hasTooltipStyle() && this.tooltipStyle.equals((Object)meta.tooltipStyle) : !meta.hasTooltipStyle()) && (this.hasItemModel() ? meta.hasItemModel() && this.itemModel.equals((Object)meta.itemModel) : !meta.hasItemModel()) && this.isUnbreakable() == meta.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? meta.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(meta.enchantmentGlintOverride) : !meta.hasEnchantmentGlintOverride()) && this.glider == meta.glider && (this.hasDamageResistant() ? meta.hasDamageResistant() && this.damageResistant.equals(meta.damageResistant) : !meta.hasDamageResistant()) && (this.hasMaxStackSize() ? meta.hasMaxStackSize() && this.maxStackSize.equals(meta.maxStackSize) : !meta.hasMaxStackSize()) && this.rarity == meta.rarity && (this.hasUseRemainder() ? meta.hasUseRemainder() && this.useRemainder.equals((Object)meta.useRemainder) : !meta.hasUseRemainder()) && (this.hasUseCooldown() ? meta.hasUseCooldown() && this.useCooldown.equals(meta.useCooldown) : !meta.hasUseCooldown()) && (this.hasFood() ? meta.hasFood() && this.food.equals(meta.food) : !meta.hasFood()) && (this.hasTool() ? meta.hasTool() && this.tool.equals(meta.tool) : !meta.hasTool()) && (this.hasEquippable() ? meta.hasEquippable() && this.equippable.equals(meta.equippable) : !meta.hasEquippable()) && (this.hasJukeboxPlayable() ? meta.hasJukeboxPlayable() && this.jukebox.equals(meta.jukebox) : !meta.hasJukeboxPlayable()) && Objects.equals(this.damage, meta.damage) && (this.hasMaxDamage() ? meta.hasMaxDamage() && this.maxDamage.equals(meta.maxDamage) : !meta.hasMaxDamage()) && (this.canPlaceOnPredicates != null ? meta.canPlaceOnPredicates != null && this.canPlaceOnPredicates.equals(meta.canPlaceOnPredicates) : meta.canPlaceOnPredicates == null) && (this.canBreakPredicates != null ? meta.canBreakPredicates != null && this.canBreakPredicates.equals(meta.canBreakPredicates) : meta.canBreakPredicates == null) && this.version == meta.version;
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelDataComponent() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchantable() ? this.enchantableValue.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + this.removedTags.hashCode();
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + (this.tooltipDisplay != null ? this.tooltipDisplay.hashCode() : 0);
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.hasTooltipStyle() ? this.tooltipStyle.hashCode() : 0);
        hash = 61 * hash + (this.hasItemModel() ? this.itemModel.hashCode() : 0);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isGlider() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamageResistant() ? this.damageResistant.hashCode() : 0);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasUseRemainder() ? this.useRemainder.hashCode() : 0);
        hash = 61 * hash + (this.hasUseCooldown() ? this.useCooldown.hashCode() : 0);
        hash = 61 * hash + (this.hasFood() ? this.food.hashCode() : 0);
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + (this.hasJukeboxPlayable() ? this.jukebox.hashCode() : 0);
        hash = 61 * hash + (this.hasEquippable() ? this.equippable.hashCode() : 0);
        hash = 61 * hash + (this.hasDamageValue() ? this.damage : -1);
        hash = 61 * hash + (this.hasMaxDamage() ? this.maxDamage.hashCode() : 0);
        hash = 61 * hash + (this.attributeModifiers != null ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + (this.canPlaceOnPredicates != null ? this.canPlaceOnPredicates.hashCode() : 0);
        hash = 61 * hash + (this.canBreakPredicates != null ? this.canBreakPredicates.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<IChatBaseComponent>(this.lore);
            }
            if (this.hasCustomModelDataComponent()) {
                clone.customModelData = new CraftCustomModelDataComponent(this.customModelData);
            }
            clone.enchantableValue = this.enchantableValue;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new EnchantmentMap(this.enchantments);
            }
            if (this.attributeModifiers != null) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.l();
            }
            clone.removedTags = Sets.newHashSet(this.removedTags);
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getTagsCloned(), DATA_TYPE_REGISTRY);
            if (this.tooltipDisplay != null) {
                clone.tooltipDisplay = new TooltipDisplay(this.tooltipDisplay.a(), (SequencedSet<DataComponentType<?>>)new ReferenceLinkedOpenHashSet(this.tooltipDisplay.b()));
            }
            clone.tooltipStyle = this.tooltipStyle;
            clone.itemModel = this.itemModel;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.glider = this.glider;
            clone.damageResistant = this.damageResistant;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasUseRemainder()) {
                clone.useRemainder = this.useRemainder.clone();
            }
            if (this.hasUseCooldown()) {
                clone.useCooldown = new CraftUseCooldownComponent(this.useCooldown);
            }
            if (this.hasFood()) {
                clone.food = new CraftFoodComponent(this.food);
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasEquippable()) {
                clone.equippable = new CraftEquippableComponent(this.equippable);
            }
            if (this.hasJukeboxPlayable()) {
                clone.jukebox = new CraftJukeboxComponent(this.jukebox);
            }
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.version = this.version;
            if (this.canPlaceOnPredicates != null) {
                clone.canPlaceOnPredicates = List.copyOf(this.canPlaceOnPredicates);
            }
            if (this.canBreakPredicates != null) {
                clone.canBreakPredicates = List.copyOf(this.canBreakPredicates);
            }
            return clone;
        }
        catch (CloneNotSupportedException e2) {
            throw new Error(e2);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        boolean canPlaceOnAddToUnhandled;
        boolean canBreakAddToUnhandled;
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (IChatBaseComponent component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelDataComponent()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasEnchantable()) {
            builder.put((Object)CraftMetaItem.ENCHANTABLE.BUKKIT, (Object)this.enchantableValue);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(CraftItemFlag.bukkitToString(hideFlagEnum));
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.hasTooltipStyle()) {
            builder.put((Object)CraftMetaItem.TOOLTIP_STYLE.BUKKIT, (Object)this.tooltipStyle.toString());
        }
        if (this.hasItemModel()) {
            builder.put((Object)CraftMetaItem.ITEM_MODEL.BUKKIT, (Object)this.itemModel.toString());
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isGlider()) {
            builder.put((Object)CraftMetaItem.GLIDER.BUKKIT, (Object)this.glider);
        }
        if (this.hasDamageResistant()) {
            builder.put((Object)CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, (Object)this.damageResistant.b().toString());
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasUseRemainder()) {
            builder.put((Object)CraftMetaItem.USE_REMAINDER.BUKKIT, (Object)this.useRemainder);
        }
        if (this.hasUseCooldown()) {
            builder.put((Object)CraftMetaItem.USE_COOLDOWN.BUKKIT, (Object)this.useCooldown);
        }
        if (this.hasFood()) {
            builder.put((Object)CraftMetaItem.FOOD.BUKKIT, (Object)this.food);
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasEquippable()) {
            builder.put((Object)CraftMetaItem.EQUIPPABLE.BUKKIT, (Object)this.equippable);
        }
        if (this.hasJukeboxPlayable()) {
            builder.put((Object)CraftMetaItem.JUKEBOX_PLAYABLE.BUKKIT, (Object)this.jukebox);
        }
        if (this.hasDamageValue()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        HashMap<String, NBTBase> internalTags = new HashMap<String, NBTBase>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            NBTTagCompound internal = new NBTTagCompound();
            for (Map.Entry e2 : internalTags.entrySet()) {
                internal.a((String)e2.getKey(), (NBTBase)e2.getValue());
            }
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a(internal, buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        boolean bl = canBreakAddToUnhandled = this.canBreakPredicates != null && !this.canBreakPredicates.isEmpty();
        if (canBreakAddToUnhandled) {
            this.unhandledTags.a(DataComponents.n, new AdventureModePredicate(this.canBreakPredicates));
        }
        boolean bl2 = canPlaceOnAddToUnhandled = this.canPlaceOnPredicates != null && !this.canPlaceOnPredicates.isEmpty();
        if (canPlaceOnAddToUnhandled) {
            this.unhandledTags.a(DataComponents.m, new AdventureModePredicate(this.canPlaceOnPredicates));
        }
        if (!this.unhandledTags.isEmpty()) {
            NBTBase unhandled = (NBTBase)DataComponentPatch.b.encodeStart(CraftRegistry.getMinecraftRegistry().a(DynamicOpsNBT.a), (Object)this.unhandledTags.a()).getOrThrow(IllegalStateException::new);
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a((NBTTagCompound)unhandled, buf);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (canBreakAddToUnhandled) {
            this.unhandledTags.clear(DataComponents.n);
        }
        if (canPlaceOnAddToUnhandled) {
            this.unhandledTags.clear(DataComponents.m);
        }
        if (!this.removedTags.isEmpty()) {
            IRegistryCustom registryAccess = CraftRegistry.getMinecraftRegistry();
            IRegistry<DataComponentType<?>> componentTypeRegistry = registryAccess.f(Registries.r);
            ArrayList<String> removedTags = new ArrayList<String>();
            for (DataComponentType<?> removed : this.removedTags) {
                String componentKey = componentTypeRegistry.d(removed).orElseThrow().a().toString();
                removedTags.add(componentKey);
            }
            builder.put((Object)"removed", removedTags);
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null) {
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                NBTCompressedStreamTools.a(this.customTag, buf);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, NBTBase> unhandledTags) {
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)CraftEnchantment.bukkitToString(enchant.getKey()), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void serializeModifiers(Multimap<Attribute, org.bukkit.attribute.AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(CraftAttribute.bukkitToString((Attribute)entry.getKey()), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<IChatBaseComponent> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            IChatBaseComponent component;
            if (object instanceof BaseComponent[]) {
                BaseComponent[] baseComponentArr = (BaseComponent[])object;
                addTo.add(CraftChatMessage.bungeeToVanilla(baseComponentArr));
                continue;
            }
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(IChatBaseComponent.i());
                continue;
            }
            String entry = object.toString();
            IChatBaseComponent iChatBaseComponent = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add(IChatBaseComponent.i());
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<DataComponentType<?>> getTopLevelHandledDcts(Class<? extends CraftMetaItem> clazz) {
        Map<Class<? extends CraftMetaItem>, Set<DataComponentType<?>>> map = HANDLED_DCTS_PER_TYPE;
        synchronized (map) {
            if (HANDLED_DCTS_PER_TYPE.isEmpty()) {
                HashMap map2 = new HashMap();
                map2.put(CraftMetaArmor.class, Set.of(CraftMetaArmor.TRIM.TYPE));
                map2.put(CraftMetaArmorStand.class, Set.of(CraftMetaArmorStand.ENTITY_TAG.TYPE));
                map2.put(CraftMetaAxolotlBucket.class, Set.of(CraftMetaAxolotlBucket.ENTITY_TAG.TYPE, CraftMetaAxolotlBucket.BUCKET_ENTITY_TAG.TYPE));
                map2.put(CraftMetaBanner.class, Set.of(CraftMetaBanner.PATTERNS.TYPE));
                map2.put(CraftMetaShield.class, Set.of(CraftMetaShield.BASE_COLOR.TYPE, CraftMetaBanner.PATTERNS.TYPE));
                map2.put(CraftMetaBlockState.class, Set.of(CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE));
                map2.put(CraftMetaBook.class, Set.of(CraftMetaBook.BOOK_CONTENT.TYPE));
                map2.put(CraftMetaBookSigned.class, Set.of(CraftMetaBookSigned.BOOK_CONTENT.TYPE));
                map2.put(CraftMetaBundle.class, Set.of(CraftMetaBundle.ITEMS.TYPE));
                map2.put(CraftMetaCharge.class, Set.of(CraftMetaCharge.EXPLOSION.TYPE));
                map2.put(CraftMetaColorableArmor.class, Set.of(CraftMetaArmor.TRIM.TYPE, CraftMetaLeatherArmor.COLOR.TYPE));
                map2.put(CraftMetaCompass.class, Set.of(CraftMetaCompass.LODESTONE_TARGET.TYPE));
                map2.put(CraftMetaCrossbow.class, Set.of(CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE));
                map2.put(CraftMetaEnchantedBook.class, Set.of(CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE));
                map2.put(CraftMetaEntityTag.class, Set.of(CraftMetaEntityTag.ENTITY_TAG.TYPE));
                map2.put(CraftMetaFirework.class, Set.of(CraftMetaFirework.FIREWORKS.TYPE));
                map2.put(CraftMetaKnowledgeBook.class, Set.of(CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE));
                map2.put(CraftMetaLeatherArmor.class, Set.of(CraftMetaLeatherArmor.COLOR.TYPE));
                map2.put(CraftMetaMap.class, Set.of(CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_ID.TYPE));
                map2.put(CraftMetaMusicInstrument.class, Set.of(CraftMetaMusicInstrument.GOAT_HORN_INSTRUMENT.TYPE));
                map2.put(CraftMetaOminousBottle.class, Set.of(CraftMetaOminousBottle.OMINOUS_BOTTLE_AMPLIFIER.TYPE));
                map2.put(CraftMetaPotion.class, Set.of(CraftMetaPotion.POTION_CONTENTS.TYPE));
                map2.put(CraftMetaSkull.class, Set.of(CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSkull.NOTE_BLOCK_SOUND.TYPE));
                map2.put(CraftMetaSpawnEgg.class, Set.of(CraftMetaSpawnEgg.ENTITY_TAG.TYPE));
                map2.put(CraftMetaSuspiciousStew.class, Set.of(CraftMetaSuspiciousStew.EFFECTS.TYPE));
                map2.put(CraftMetaTropicalFishBucket.class, Set.of(CraftMetaTropicalFishBucket.ENTITY_TAG.TYPE, CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.TYPE));
                for (Map.Entry entry : map2.entrySet()) {
                    ArrayList topLevelTags = new ArrayList((Collection)entry.getValue());
                    topLevelTags.addAll(DEFAULT_HANDLED_DCTS);
                    HANDLED_DCTS_PER_TYPE.put((Class)entry.getKey(), Set.copyOf(topLevelTags));
                }
            }
            return HANDLED_DCTS_PER_TYPE.getOrDefault(clazz, DEFAULT_HANDLED_DCTS);
        }
    }

    protected static <T> Optional<? extends T> getOrEmpty(DataComponentPatch tag, ItemMetaKeyType<T> type) {
        return CraftMetaItem.getOrEmpty(tag, type.TYPE);
    }

    protected static <T> Optional<? extends T> getOrEmpty(DataComponentPatch tag, DataComponentType<T> type) {
        Optional<T> result = tag.a(type);
        return result != null ? result : Optional.empty();
    }

    public Set<Material> getCanDestroy() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyMaterial(this.canBreakPredicates);
    }

    public void setCanDestroy(Set<Material> canDestroy) {
        Preconditions.checkArgument((canDestroy != null ? 1 : 0) != 0, (Object)"Cannot replace with null set!");
        this.canBreakPredicates = CraftMetaItem.convertFromLegacyMaterial(canDestroy);
    }

    public Set<Material> getCanPlaceOn() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyMaterial(this.canPlaceOnPredicates);
    }

    public void setCanPlaceOn(Set<Material> canPlaceOn) {
        Preconditions.checkArgument((canPlaceOn != null ? 1 : 0) != 0, (Object)"Cannot replace with null set!");
        this.canPlaceOnPredicates = CraftMetaItem.convertFromLegacyMaterial(canPlaceOn);
    }

    private static List<CriterionConditionBlock> convertFromLegacyMaterial(Collection<Material> materials) {
        IRegistry<Block> blockRegistry = CraftRegistry.getMinecraftRegistry().f(Registries.i);
        return materials.stream().map(m2 -> CriterionConditionBlock.a.a().a((HolderGetter<Block>)blockRegistry, CraftBlockType.bukkitToMinecraft(m2)).b()).toList();
    }

    private static Set<Material> convertToLegacyMaterial(List<CriterionConditionBlock> predicates) {
        return predicates.stream().flatMap(p2 -> p2.b().map(HolderSet::a).orElse(Stream.empty())).map(holder -> CraftBlockType.minecraftToBukkit((Block)holder.a())).collect(Collectors.toSet());
    }

    public Set<Namespaced> getDestroyableKeys() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canBreakPredicates);
    }

    public void setDestroyableKeys(Collection<Namespaced> canDestroy) {
        Preconditions.checkArgument((canDestroy != null ? 1 : 0) != 0, (Object)"Cannot replace with null collection!");
        Preconditions.checkArgument((boolean)CraftMetaItem.ofAcceptableType(canDestroy), (Object)"Can only use NamespacedKey or NamespacedTag objects!");
        this.canBreakPredicates = CraftMetaItem.convertFromLegacyNamespaced(canDestroy);
    }

    public Set<Namespaced> getPlaceableKeys() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canPlaceOnPredicates);
    }

    public void setPlaceableKeys(Collection<Namespaced> canPlaceOn) {
        Preconditions.checkArgument((canPlaceOn != null ? 1 : 0) != 0, (Object)"Cannot replace with null collection!");
        Preconditions.checkArgument((boolean)CraftMetaItem.ofAcceptableType(canPlaceOn), (Object)"Can only use NamespacedKey or NamespacedTag objects!");
        this.canPlaceOnPredicates = CraftMetaItem.convertFromLegacyNamespaced(canPlaceOn);
    }

    private static List<CriterionConditionBlock> convertFromLegacyNamespaced(Collection<Namespaced> namespaceds) {
        ArrayList<CriterionConditionBlock> predicates = new ArrayList<CriterionConditionBlock>();
        IRegistry<Block> blockRegistry = CraftRegistry.getMinecraftRegistry().f(Registries.i);
        for (Namespaced namespaced : namespaceds) {
            if (namespaced instanceof NamespacedKey) {
                NamespacedKey key = (NamespacedKey)namespaced;
                predicates.add(CriterionConditionBlock.a.a().a(blockRegistry, CraftBlockType.bukkitToMinecraft(Objects.requireNonNull((Material)Registry.MATERIAL.get(key)))).b());
                continue;
            }
            if (!(namespaced instanceof NamespacedTag)) continue;
            NamespacedTag tag = (NamespacedTag)namespaced;
            predicates.add(CriterionConditionBlock.a.a().a(blockRegistry, TagKey.a(Registries.i, MinecraftKey.a(tag.getNamespace(), tag.getKey()))).b());
        }
        return predicates;
    }

    private static Set<Namespaced> convertToLegacyNamespaced(Collection<CriterionConditionBlock> predicates) {
        HashSet namespaceds = Sets.newHashSet();
        for (CriterionConditionBlock predicate : predicates) {
            if (predicate.b().isEmpty()) continue;
            HolderSet<Block> holders = predicate.b().get();
            if (holders instanceof HolderSet.Named) {
                HolderSet.Named named = (HolderSet.Named)holders;
                namespaceds.add(new NamespacedTag(named.h().b().b(), named.h().b().a()));
                continue;
            }
            holders.forEach(h2 -> h2.e().ifPresent(key -> namespaceds.add(new NamespacedKey(key.a().b(), key.a().a()))));
        }
        return namespaceds;
    }

    public boolean hasPlaceableKeys() {
        return this.canPlaceOnPredicates != null;
    }

    public boolean hasDestroyableKeys() {
        return this.canBreakPredicates != null;
    }

    private static boolean ofAcceptableType(Collection<Namespaced> namespacedResources) {
        for (Namespaced resource : namespacedResources) {
            if (resource instanceof NamespacedKey || resource instanceof NamespacedTag) continue;
            return false;
        }
        return true;
    }

    private static class EnchantmentMap
    extends TreeMap<Enchantment, Integer> {
        private EnchantmentMap(Map<Enchantment, Integer> enchantments) {
            this();
            this.putAll(enchantments);
        }

        private EnchantmentMap() {
            super(Comparator.comparing(o2 -> o2.getKey().toString()));
        }

        @Override
        public EnchantmentMap clone() {
            return (EnchantmentMap)super.clone();
        }
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final DataComponentType<T> TYPE;

        ItemMetaKeyType(DataComponentType<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(DataComponentType<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(DataComponentType<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    static abstract class Applicator {
        final DataComponentPatch.a builder = DataComponentPatch.a();

        Applicator() {
        }

        void skullCallback(ResolvableProfile resolvableProfile) {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.a(key.TYPE, value);
            return this;
        }

        DataComponentPatch build() {
            return this.builder.a();
        }
    }
}

