/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory.util;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.craftbukkit.v1_21_R4.inventory.util.CraftBlockInventoryConverter;
import org.bukkit.craftbukkit.v1_21_R4.inventory.util.CraftCustomInventoryConverter;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class CraftInventoryCreator {
    public static final CraftInventoryCreator INSTANCE = new CraftInventoryCreator();
    private final CraftCustomInventoryConverter defaultConverter = new CraftCustomInventoryConverter();
    private final Map<InventoryType, InventoryConverter> converterMap = new HashMap<InventoryType, InventoryConverter>();

    private CraftInventoryCreator() {
        this.converterMap.put(InventoryType.CHEST, this.defaultConverter);
        this.converterMap.put(InventoryType.DISPENSER, new CraftBlockInventoryConverter.Dispenser());
        this.converterMap.put(InventoryType.DROPPER, new CraftBlockInventoryConverter.Dropper());
        this.converterMap.put(InventoryType.FURNACE, new CraftBlockInventoryConverter.Furnace());
        this.converterMap.put(InventoryType.WORKBENCH, this.defaultConverter);
        this.converterMap.put(InventoryType.ENCHANTING, this.defaultConverter);
        this.converterMap.put(InventoryType.BREWING, new CraftBlockInventoryConverter.BrewingStand());
        this.converterMap.put(InventoryType.PLAYER, this.defaultConverter);
        this.converterMap.put(InventoryType.MERCHANT, this.defaultConverter);
        this.converterMap.put(InventoryType.ENDER_CHEST, this.defaultConverter);
        this.converterMap.put(InventoryType.ANVIL, this.defaultConverter);
        this.converterMap.put(InventoryType.SMITHING, this.defaultConverter);
        this.converterMap.put(InventoryType.BEACON, this.defaultConverter);
        this.converterMap.put(InventoryType.HOPPER, new CraftBlockInventoryConverter.Hopper());
        this.converterMap.put(InventoryType.SHULKER_BOX, this.defaultConverter);
        this.converterMap.put(InventoryType.BARREL, this.defaultConverter);
        this.converterMap.put(InventoryType.BLAST_FURNACE, new CraftBlockInventoryConverter.BlastFurnace());
        this.converterMap.put(InventoryType.LECTERN, new CraftBlockInventoryConverter.Lectern());
        this.converterMap.put(InventoryType.SMOKER, new CraftBlockInventoryConverter.Smoker());
        this.converterMap.put(InventoryType.LOOM, this.defaultConverter);
        this.converterMap.put(InventoryType.CARTOGRAPHY, this.defaultConverter);
        this.converterMap.put(InventoryType.GRINDSTONE, this.defaultConverter);
        this.converterMap.put(InventoryType.STONECUTTER, this.defaultConverter);
        this.converterMap.put(InventoryType.SMITHING_NEW, this.defaultConverter);
        this.converterMap.put(InventoryType.CRAFTER, new CraftBlockInventoryConverter.Crafter());
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.converterMap.get(type).createInventory(holder, type);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type, Component title) {
        return this.converterMap.get(type).createInventory(holder, type, title);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        return this.converterMap.get(type).createInventory(holder, type, title);
    }

    public Inventory createInventory(InventoryHolder holder, int size) {
        return this.defaultConverter.createInventory(holder, size);
    }

    public Inventory createInventory(InventoryHolder holder, int size, Component title) {
        return this.defaultConverter.createInventory(holder, size, title);
    }

    public Inventory createInventory(InventoryHolder holder, int size, String title) {
        return this.defaultConverter.createInventory(holder, size, title);
    }

    public static interface InventoryConverter {
        public Inventory createInventory(InventoryHolder var1, InventoryType var2);

        public Inventory createInventory(InventoryHolder var1, InventoryType var2, Component var3);

        public Inventory createInventory(InventoryHolder var1, InventoryType var2, String var3);
    }
}

