/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public abstract class CraftAbstractInventoryViewBuilder<V extends InventoryView>
implements InventoryViewBuilder<V> {
    protected final Containers<?> handle;
    protected boolean checkReachable = false;
    protected @Nullable Component title = null;
    protected IChatBaseComponent defaultTitle = null;

    public CraftAbstractInventoryViewBuilder(Containers<?> handle) {
        this.handle = handle;
    }

    public InventoryViewBuilder<V> title(@Nullable Component title) {
        this.title = title;
        return this;
    }

    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof EntityPlayer), (Object)"The given player must be an ServerPlayer");
        EntityPlayer serverPlayer = (EntityPlayer)craftHuman.getHandle();
        Container container = this.buildContainer(serverPlayer);
        container.checkReachable = this.checkReachable;
        container.setTitle(this.title != null ? PaperAdventure.asVanilla(this.title) : this.defaultTitle);
        return (V)container.getBukkitView();
    }

    protected abstract Container buildContainer(EntityPlayer var1);
}

