/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.packs;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R4.packs.CraftDataPack;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemType;
import org.bukkit.packs.DataPack;
import org.bukkit.packs.DataPackManager;

public class CraftDataPackManager
implements DataPackManager {
    private final ResourcePackRepository handle;

    public CraftDataPackManager(ResourcePackRepository resourcePackRepository) {
        this.handle = resourcePackRepository;
    }

    public ResourcePackRepository getHandle() {
        return this.handle;
    }

    public Collection<DataPack> getDataPacks() {
        this.getHandle().a();
        Collection<ResourcePackLoader> availablePacks = this.getHandle().d();
        return availablePacks.stream().map(CraftDataPack::new).collect(Collectors.toUnmodifiableList());
    }

    public DataPack getDataPack(NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"namespacedKey cannot be null");
        return new CraftDataPack(this.getHandle().c(namespacedKey.getKey()));
    }

    public Collection<DataPack> getEnabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return craftWorld.getHandle().L.D().a().a().stream().map(packName -> {
            ResourcePackLoader resourcePackLoader = this.getHandle().c((String)packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public Collection<DataPack> getDisabledDataPacks(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return craftWorld.getHandle().L.D().a().b().stream().map(packName -> {
            ResourcePackLoader resourcePackLoader = this.getHandle().c((String)packName);
            if (resourcePackLoader != null) {
                return new CraftDataPack(resourcePackLoader);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public boolean isEnabledByFeature(Material material, World world) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material cannot be null");
        Preconditions.checkArgument((material.isItem() || material.isBlock() ? 1 : 0) != 0, (Object)"material need to be a item or block");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        if (material.isItem()) {
            return CraftItemType.bukkitToMinecraft(material).a(craftWorld.getHandle().K());
        }
        if (material.isBlock()) {
            return CraftBlockType.bukkitToMinecraft(material).a(craftWorld.getHandle().K());
        }
        return false;
    }

    public boolean isEnabledByFeature(ItemType itemType, World world) {
        Preconditions.checkArgument((itemType != null ? 1 : 0) != 0, (Object)"itemType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return CraftItemType.bukkitToMinecraftNew((ItemType)itemType.typed()).a(craftWorld.getHandle().K());
    }

    public boolean isEnabledByFeature(BlockType blockType, World world) {
        Preconditions.checkArgument((blockType != null ? 1 : 0) != 0, (Object)"blockType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        return CraftBlockType.bukkitToMinecraftNew((BlockType)blockType.typed()).a(craftWorld.getHandle().K());
    }

    public boolean isEnabledByFeature(EntityType entityType, World world) {
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"entityType cannot be null");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (Object)"EntityType.UNKNOWN its not allowed here");
        CraftWorld craftWorld = (CraftWorld)world;
        EntityTypes<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entityType);
        return nmsEntity.a(craftWorld.getHandle().K());
    }
}

