/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.potion;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.papermc.paper.util.Holderable;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R4.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R4.potion.CraftPotionEffectTypeCategory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftPotionEffectType
extends PotionEffectType
implements Holderable<MobEffectList>,
PaperFeatureDependent<MobEffectList> {
    private final Holder<MobEffectList> holder;
    private final Supplier<Integer> id;

    public static PotionEffectType minecraftHolderToBukkit(Holder<MobEffectList> minecraft) {
        return CraftPotionEffectType.minecraftToBukkit(minecraft.a());
    }

    public static PotionEffectType minecraftToBukkit(MobEffectList minecraft) {
        return (PotionEffectType)CraftRegistry.minecraftToBukkit(minecraft, Registries.W);
    }

    public static MobEffectList bukkitToMinecraft(PotionEffectType bukkit) {
        return (MobEffectList)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<MobEffectList> bukkitToMinecraftHolder(PotionEffectType bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.W);
    }

    public CraftPotionEffectType(Holder<MobEffectList> holder) {
        this.holder = holder;
        this.id = Suppliers.memoize(() -> CraftRegistry.getMinecraftRegistry(Registries.W).a((MobEffectList)this.getHandle()) + 1);
    }

    @Override
    public Holder<MobEffectList> getHolder() {
        return this.holder;
    }

    @Override
    public NamespacedKey getKey() {
        return PaperFeatureDependent.super.getKey();
    }

    public double getDurationModifier() {
        return 1.0;
    }

    public int getId() {
        return this.id.get();
    }

    public String getName() {
        return switch (this.getId()) {
            case 1 -> "SPEED";
            case 2 -> "SLOW";
            case 3 -> "FAST_DIGGING";
            case 4 -> "SLOW_DIGGING";
            case 5 -> "INCREASE_DAMAGE";
            case 6 -> "HEAL";
            case 7 -> "HARM";
            case 8 -> "JUMP";
            case 9 -> "CONFUSION";
            case 10 -> "REGENERATION";
            case 11 -> "DAMAGE_RESISTANCE";
            case 12 -> "FIRE_RESISTANCE";
            case 13 -> "WATER_BREATHING";
            case 14 -> "INVISIBILITY";
            case 15 -> "BLINDNESS";
            case 16 -> "NIGHT_VISION";
            case 17 -> "HUNGER";
            case 18 -> "WEAKNESS";
            case 19 -> "POISON";
            case 20 -> "WITHER";
            case 21 -> "HEALTH_BOOST";
            case 22 -> "ABSORPTION";
            case 23 -> "SATURATION";
            case 24 -> "GLOWING";
            case 25 -> "LEVITATION";
            case 26 -> "LUCK";
            case 27 -> "UNLUCK";
            case 28 -> "SLOW_FALLING";
            case 29 -> "CONDUIT_POWER";
            case 30 -> "DOLPHINS_GRACE";
            case 31 -> "BAD_OMEN";
            case 32 -> "HERO_OF_THE_VILLAGE";
            case 33 -> "DARKNESS";
            default -> this.getKey().toString();
        };
    }

    public PotionEffect createEffect(int duration, int amplifier) {
        return new PotionEffect((PotionEffectType)this, this.isInstant() ? 1 : (int)((double)duration * this.getDurationModifier()), amplifier);
    }

    public boolean isInstant() {
        return ((MobEffectList)this.getHandle()).a();
    }

    public PotionEffectTypeCategory getCategory() {
        return CraftPotionEffectTypeCategory.minecraftToBukkit(((MobEffectList)this.getHandle()).h());
    }

    public Color getColor() {
        return Color.fromRGB((int)((MobEffectList)this.getHandle()).i());
    }

    public String getTranslationKey() {
        return ((MobEffectList)this.getHandle()).f();
    }

    public Map<Attribute, AttributeModifier> getEffectAttributes() {
        HashMap attributeMap = new HashMap();
        ((MobEffectList)this.getHandle()).d.forEach((attribute, attributeModifier) -> attributeMap.put(CraftAttribute.minecraftHolderToBukkit(attribute), CraftAttributeInstance.convert(attributeModifier.a(0))));
        return Map.copyOf(attributeMap);
    }

    public double getAttributeModifierAmount(Attribute attribute, int effectAmplifier) {
        Preconditions.checkArgument((effectAmplifier >= 0 ? 1 : 0) != 0, (Object)"effectAmplifier must be greater than or equal to 0");
        Holder<AttributeBase> nmsAttribute = CraftAttribute.bukkitToMinecraftHolder(attribute);
        Preconditions.checkArgument((boolean)((MobEffectList)this.getHandle()).d.containsKey(nmsAttribute), (Object)(String.valueOf(attribute) + " is not present on " + String.valueOf(this.getKey())));
        return ((MobEffectList)this.getHandle()).d.get(nmsAttribute).a(effectAmplifier).b();
    }

    public PotionEffectType.Category getEffectCategory() {
        return CraftPotionEffectType.fromNMS(((MobEffectList)this.getHandle()).h());
    }

    public String translationKey() {
        return ((MobEffectList)this.getHandle()).f();
    }

    public static PotionEffectType.Category fromNMS(MobEffectInfo mobEffectInfo) {
        return switch (mobEffectInfo) {
            default -> throw new MatchException(null, null);
            case MobEffectInfo.a -> PotionEffectType.Category.BENEFICIAL;
            case MobEffectInfo.b -> PotionEffectType.Category.HARMFUL;
            case MobEffectInfo.c -> PotionEffectType.Category.NEUTRAL;
        };
    }

    public boolean equals(Object other) {
        return PaperFeatureDependent.super.implEquals(other);
    }

    public int hashCode() {
        return PaperFeatureDependent.super.implHashCode();
    }

    public String toString() {
        return PaperFeatureDependent.super.implToString();
    }
}

