/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.projectiles;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WindCharge;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final TileEntityDispenser dispenserBlock;

    public CraftBlockProjectileSource(TileEntityDispenser dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return CraftBlock.at(this.dispenserBlock.i(), this.dispenserBlock.ax_());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        SourceBlock blockSource = new SourceBlock((WorldServer)this.dispenserBlock.i(), this.dispenserBlock.ax_(), this.dispenserBlock.m(), this.dispenserBlock);
        EnumDirection direction = blockSource.d().c(BlockDispenser.b);
        World world = this.dispenserBlock.i();
        Item item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = Items.rs;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = Items.rH;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = Items.vf;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? Items.wC : Items.wz;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                item = Items.wB;
            } else if (SpectralArrow.class.isAssignableFrom(projectile)) {
                item = Items.wA;
            } else if (Arrow.class.isAssignableFrom(projectile)) {
                item = Items.pk;
            }
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            if (WindCharge.class.isAssignableFrom(projectile)) {
                item = Items.vh;
            } else if (SmallFireball.class.isAssignableFrom(projectile)) {
                item = Items.vg;
            }
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = Items.vE;
        }
        Preconditions.checkArgument((boolean)(item instanceof ProjectileItem), (String)"Projectile '%s' not supported", (Object)projectile.getSimpleName());
        ItemStack itemstack = new ItemStack(item);
        ProjectileItem projectileItem = (ProjectileItem)((Object)item);
        ProjectileItem.a dispenseConfig = projectileItem.a();
        IPosition position = dispenseConfig.b().getDispensePosition(blockSource, direction);
        IProjectile launch = projectileItem.a(world, position, itemstack, direction);
        launch.projectileSource = this;
        projectileItem.a(launch, direction.j(), direction.k(), direction.l(), dispenseConfig.d(), dispenseConfig.c());
        if (velocity != null) {
            launch.getBukkitEntity().setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Projectile)launch.getBukkitEntity());
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

