/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R4.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_21_R4.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_21_R4.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R4.scoreboard.CraftTeam;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements org.bukkit.scoreboard.Scoreboard {
    private final Scoreboard board;
    public boolean registeredGlobally = false;

    CraftScoreboard(Scoreboard board) {
        this.board = board;
    }

    public Objective registerNewObjective(String name, String criteria, Component displayName, RenderType renderType) {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    public Objective registerNewObjective(String name, Criteria criteria, Component displayName, RenderType renderType) throws IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"The name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.getHandle().a(name) == null ? 1 : 0) != 0, (String)"An objective of name '%s' already exists", (Object)name);
        if (((CraftCriteria)criteria).criteria != IScoreboardCriteria.c && !this.registeredGlobally) {
            MinecraftServer.getServer().server.getScoreboardManager().registerScoreboardForVanilla(this);
            this.registeredGlobally = true;
        }
        ScoreboardObjective objective = this.getHandle().a(name, ((CraftCriteria)criteria).criteria, PaperAdventure.asVanilla(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType), true, null);
        return new CraftObjective(this, objective);
    }

    public Objective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    public Objective getObjective(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Objective name cannot be null");
        ScoreboardObjective nms = this.getHandle().a(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria name cannot be null");
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ScoreboardObjective objective : this.getHandle().b()) {
            CraftObjective craftObjective = new CraftObjective(this, objective);
            if (!craftObjective.getCriteria().equals(criteria)) continue;
            result.add((Object)craftObjective);
        }
        return result.build();
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(Criteria criteria) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"Criteria cannot be null");
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (ScoreboardObjective objective : this.getHandle().b()) {
            CraftObjective craftObjective = new CraftObjective(this, objective);
            if (!craftObjective.getTrackedCriteria().equals((Object)criteria)) continue;
            result.add((Object)craftObjective);
        }
        return result.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getHandle().b(), input -> new CraftObjective(this, (ScoreboardObjective)input)));
    }

    public Objective getObjective(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Display slot cannot be null");
        ScoreboardObjective objective = this.getHandle().a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) {
        return this.getScores(CraftScoreboard.getScoreHolder(player));
    }

    public ImmutableSet<Score> getScores(String entry) {
        return this.getScores(CraftScoreboard.getScoreHolder(entry));
    }

    private ImmutableSet<Score> getScores(ScoreHolder entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (ScoreboardObjective objective : this.getHandle().b()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    public void resetScores(OfflinePlayer player) {
        this.resetScores(CraftScoreboard.getScoreHolder(player));
    }

    public void resetScores(String entry) {
        this.resetScores(CraftScoreboard.getScoreHolder(entry));
    }

    private void resetScores(ScoreHolder entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        for (ScoreboardObjective objective : this.getHandle().b()) {
            this.getHandle().e(entry, objective);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        ScoreboardTeam team = this.getHandle().e(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getEntryTeam(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        ScoreboardTeam team = this.getHandle().e(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getTeam(String teamName) {
        Preconditions.checkArgument((teamName != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        ScoreboardTeam team = this.getHandle().b(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getHandle().f(), input -> new CraftTeam(this, (ScoreboardTeam)input)));
    }

    public Team registerNewTeam(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Team name cannot be null");
        Preconditions.checkArgument((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"Team name '%s' is longer than the limit of 32767 characters (%s)", (Object)name, (int)name.length());
        Preconditions.checkArgument((this.getHandle().b(name) == null ? 1 : 0) != 0, (String)"Team name '%s' is already in use", (Object)name);
        return new CraftTeam(this, this.getHandle().c(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (ScoreHolder playerName : this.getHandle().d()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName.cI()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (ScoreHolder entry : this.getHandle().d()) {
            entries.add((Object)entry.cI());
        }
        return entries.build();
    }

    public void clearSlot(DisplaySlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Slot cannot be null");
        this.getHandle().a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public ImmutableSet<Score> getScoresFor(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getScores(((CraftEntity)entity).getHandle());
    }

    public void resetScoresFor(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.resetScores(((CraftEntity)entity).getHandle());
    }

    public Team getEntityTeam(Entity entity) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getEntryTeam(((CraftEntity)entity).getHandle().cI());
    }

    public Scoreboard getHandle() {
        return this.board;
    }

    static ScoreHolder getScoreHolder(String entry) {
        return () -> entry;
    }

    static ScoreHolder getScoreHolder(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        if (player instanceof CraftPlayer) {
            CraftPlayer craft = (CraftPlayer)player;
            return craft.getHandle();
        }
        return CraftScoreboard.getScoreHolder(player.getName());
    }
}

