/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.tag;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.bukkit.GameEvent;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R4.tag.CraftTag;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.jetbrains.annotations.NotNull;

public class CraftGameEventTag
extends CraftTag<net.minecraft.world.level.gameevent.GameEvent, GameEvent> {
    private static final Map<GameEvent, ResourceKey<net.minecraft.world.level.gameevent.GameEvent>> KEY_CACHE = Collections.synchronizedMap(new IdentityHashMap());

    public CraftGameEventTag(IRegistry<net.minecraft.world.level.gameevent.GameEvent> registry, TagKey<net.minecraft.world.level.gameevent.GameEvent> tag) {
        super(registry, tag);
    }

    public boolean isTagged(@NotNull GameEvent gameEvent) {
        return this.registry.b(KEY_CACHE.computeIfAbsent(gameEvent, event -> ResourceKey.a(Registries.H, CraftNamespacedKey.toMinecraft(event.getKey())))).a(this.tag);
    }

    @NotNull
    public Set<GameEvent> getValues() {
        return this.getHandle().a().map(nms -> Objects.requireNonNull(GameEvent.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft(BuiltInRegistries.a.b((net.minecraft.world.level.gameevent.GameEvent)nms.a()))), () -> String.valueOf(nms) + " is not a recognized game event")).collect(Collectors.toUnmodifiableSet());
    }
}

