/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final GeneratorAccess world;
    private final Map<BlockPosition, IBlockData> dataMap = new HashMap<BlockPosition, IBlockData>();
    private final Map<BlockPosition, TileEntity> entityMap = new HashMap<BlockPosition, TileEntity>();
    private final LinkedHashMap<BlockPosition, CraftBlockState> blocks;

    public BlockStateListPopulator(GeneratorAccess world) {
        this(world, new LinkedHashMap<BlockPosition, CraftBlockState>());
    }

    private BlockStateListPopulator(GeneratorAccess world, LinkedHashMap<BlockPosition, CraftBlockState> blocks) {
        this.world = world;
        this.blocks = blocks;
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        IBlockData state = this.dataMap.get(pos);
        return state != null ? state : this.world.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        IBlockData state = this.dataMap.get(pos);
        return state != null ? state.y() : this.world.b_(pos);
    }

    @Override
    public TileEntity c_(BlockPosition pos) {
        if (this.entityMap.containsKey(pos)) {
            return this.entityMap.get(pos);
        }
        return this.world.c_(pos);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int recursionLeft) {
        pos = pos.j();
        this.blocks.remove(pos);
        this.dataMap.put(pos, state);
        if (state.x()) {
            this.entityMap.put(pos, ((ITileEntity)((Object)state.b())).a(pos, state));
        } else {
            this.entityMap.put(pos, null);
        }
        CraftBlockState snapshot = (CraftBlockState)CraftBlock.at(this, pos).getState();
        snapshot.setFlags(flags);
        snapshot.setWorldHandle(this.world);
        this.blocks.put(pos, snapshot);
        return true;
    }

    @Override
    public WorldServer getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState snapshot : this.blocks.values()) {
            if (!(snapshot instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)snapshot).refreshSnapshot();
        }
    }

    public void placeBlocks() {
        this.placeSomeBlocks($ -> true);
    }

    public void placeSomeBlocks(Predicate<? super BlockState> filter) {
        this.placeSomeBlocks($ -> {}, filter);
    }

    public void placeBlocks(Consumer<? super CraftBlockState> beforeRun) {
        this.placeSomeBlocks(beforeRun, $ -> true);
    }

    public void placeSomeBlocks(Consumer<? super CraftBlockState> beforeRun, Predicate<? super BlockState> filter) {
        for (CraftBlockState state : this.blocks.values()) {
            if (!filter.test(state)) continue;
            beforeRun.accept(state);
            state.place(state.getFlags());
        }
    }

    public List<CraftBlockState> getSnapshotBlocks() {
        return new ArrayList<CraftBlockState>(this.blocks.values());
    }

    @Override
    public int K_() {
        return this.world.K_();
    }

    @Override
    public int L_() {
        return this.world.L_();
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    @Override
    public DimensionManager F_() {
        return this.world.F_();
    }

    @Override
    public IRegistryCustom J_() {
        return this.world.J_();
    }

    @Override
    public WorldData C_() {
        return this.world.C_();
    }

    @Override
    public long I_() {
        return this.world.I_();
    }

    @Override
    public RandomSource G_() {
        return this.world.G_();
    }

    @Override
    public <T extends TileEntity> Optional<T> a(BlockPosition pos, TileEntityTypes<T> type) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null && blockEntity.p() == type ? Optional.of(blockEntity) : Optional.empty();
    }

    @Override
    public BlockPosition a(HeightMap.Type heightmap, BlockPosition pos) {
        return this.world.a(heightmap, pos);
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        return this.world.a(heightmap, x2, z2);
    }

    @Override
    public int b(BlockPosition pos, int amount) {
        return this.world.b(pos, amount);
    }

    @Override
    public int a(EnumSkyBlock lightLayer, BlockPosition pos) {
        return this.world.a(lightLayer, pos);
    }
}

