/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;

public final class CraftLocation {
    private CraftLocation() {
    }

    public static Location toBukkit(Vec3D vec3) {
        return CraftLocation.toBukkit(vec3, null);
    }

    public static Location toBukkit(Vec3D vec3, World world) {
        return CraftLocation.toBukkit(vec3, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(Vec3D vec3, World world, float yaw, float pitch) {
        return new Location(world, vec3.a(), vec3.b(), vec3.c(), yaw, pitch);
    }

    public static Location toBukkit(BlockPosition pos) {
        return CraftLocation.toBukkit(pos, (World)null);
    }

    public static Location toBukkit(BlockPosition pos, net.minecraft.world.level.World world) {
        return CraftLocation.toBukkit(pos, (World)world.getWorld(), 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPosition pos, World world) {
        return CraftLocation.toBukkit(pos, world, 0.0f, 0.0f);
    }

    public static Location toBukkit(BlockPosition pos, World world, float yaw, float pitch) {
        return new Location(world, (double)pos.u(), (double)pos.v(), (double)pos.w(), yaw, pitch);
    }

    public static Location toBukkit(PathPoint point, net.minecraft.world.level.World world) {
        return new Location((World)world.getWorld(), (double)point.a, (double)point.b, (double)point.c);
    }

    public static BlockPosition toBlockPosition(Location loc) {
        return new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static GlobalPos toGlobalPos(Location loc) {
        return GlobalPos.a(((CraftWorld)loc.getWorld()).getHandle().aj(), CraftLocation.toBlockPosition(loc));
    }

    public static Location fromGlobalPos(GlobalPos globalPos) {
        return CraftLocation.toBukkit(globalPos.b(), (net.minecraft.world.level.World)MinecraftServer.getServer().a(globalPos.a()));
    }

    public static Vec3D toVec3(Location loc) {
        return new Vec3D(loc.getX(), loc.getY(), loc.getZ());
    }
}

