/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R4.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R4.util.DelegatedGeneratorAccess;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.Nullable;

public class TransformerGeneratorAccess
extends DelegatedGeneratorAccess {
    private CraftStructureTransformer structureTransformer;

    public void setStructureTransformer(CraftStructureTransformer structureTransformer) {
        this.structureTransformer = structureTransformer;
    }

    public CraftStructureTransformer getStructureTransformer() {
        return this.structureTransformer;
    }

    public boolean canTransformBlocks() {
        return this.structureTransformer != null && this.structureTransformer.canTransformBlocks();
    }

    @Override
    public boolean b(Entity entity) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(entity)) {
            return false;
        }
        return super.b(entity);
    }

    @Override
    public boolean addFreshEntity(Entity entity, @Nullable CreatureSpawnEvent.SpawnReason reason) {
        if (this.structureTransformer != null && !this.structureTransformer.transformEntity(entity)) {
            return false;
        }
        return super.addFreshEntity(entity, reason);
    }

    public boolean setCraftBlock(BlockPosition position, CraftBlockState craftBlockState, int flags, int recursionLeft) {
        TileEntity blockEntity;
        craftBlockState = this.structureTransformer.transformCraftState(craftBlockState);
        IBlockData snapshot = craftBlockState.getHandle();
        boolean result = super.a(position, snapshot, flags, recursionLeft);
        Fluid fluidState = this.b_(position);
        if (!fluidState.c()) {
            this.a(position, fluidState.a(), 0);
        }
        if (StructurePiece.h.contains(snapshot.b())) {
            this.z(position).e(position);
        }
        if ((blockEntity = this.c_(position)) != null && craftBlockState instanceof CraftBlockEntityState) {
            CraftBlockEntityState craftEntityState = (CraftBlockEntityState)craftBlockState;
            blockEntity.c(craftEntityState.getSnapshotNBT(), this.J_());
        }
        return result;
    }

    public boolean setCraftBlock(BlockPosition pos, CraftBlockState craftBlockState, int flags) {
        return this.setCraftBlock(pos, craftBlockState, flags, 512);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int recursionLeft) {
        if (this.canTransformBlocks()) {
            return this.setCraftBlock(pos, (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)this, pos, state, null), flags, recursionLeft);
        }
        return super.a(pos, state, flags, recursionLeft);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags) {
        return this.a(pos, state, flags, 512);
    }
}

