/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.item.EntityItem;
import org.spigotmc.SpigotWorldConfig;

public final class TrackingRange {
    private TrackingRange() {
    }

    public static int getEntityTrackingRange(Entity entity, int defaultRange) {
        if (defaultRange == 0) {
            return defaultRange;
        }
        SpigotWorldConfig config = entity.dV().spigotConfig;
        if (entity instanceof EntityPlayer) {
            return config.playerTrackingRange;
        }
        switch (entity.activationType) {
            case RAIDER: 
            case MONSTER: 
            case FLYING_MONSTER: {
                return config.monsterTrackingRange;
            }
            case WATER: 
            case VILLAGER: 
            case ANIMAL: {
                return config.animalTrackingRange;
            }
        }
        if (entity instanceof EntityItemFrame || entity instanceof EntityPainting || entity instanceof EntityItem || entity instanceof EntityExperienceOrb) {
            return config.miscTrackingRange;
        }
        if (entity instanceof Display) {
            return config.displayTrackingRange;
        }
        if (entity instanceof EntityEnderDragon) {
            return ((WorldServer)entity.dV()).m().a.R;
        }
        return config.otherTrackingRange;
    }
}

